/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.ingestion;

import com.facebook.presto.druid.metadata.DruidColumnInfo;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;

public class DruidIngestionTableHandle
implements ConnectorInsertTableHandle,
ConnectorOutputTableHandle {
    private final String schemaName;
    private final String tableName;
    private final List<DruidColumnInfo> columns;

    @JsonCreator
    public DruidIngestionTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="columns") List<DruidColumnInfo> columns) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.columns = Objects.requireNonNull(columns, "columns is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<DruidColumnInfo> getColumns() {
        return this.columns;
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DruidIngestionTableHandle other = (DruidIngestionTableHandle)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).toString();
    }
}

