/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.zip;

import com.facebook.presto.druid.zip.ExtraData;
import java.util.LinkedHashMap;
import java.util.Map;

class ExtraDataList {
    private final Map<Short, ExtraData> entries;

    public ExtraDataList() {
        this.entries = new LinkedHashMap<Short, ExtraData>();
    }

    public ExtraDataList(ExtraDataList other) {
        this.entries = new LinkedHashMap<Short, ExtraData>(other.getEntries());
    }

    public Map<Short, ExtraData> getEntries() {
        return this.entries;
    }

    public ExtraDataList(ExtraData ... extra) {
        this();
        for (ExtraData e : extra) {
            this.add(e);
        }
    }

    public void add(ExtraData entry) {
        if (this.getLength() + entry.getLength() > 65535) {
            throw new IllegalArgumentException("adding entry will make the extra field be too long");
        }
        this.entries.put(entry.getId(), entry);
    }

    public ExtraDataList(byte[] buffer) {
        ExtraData extra;
        if (buffer.length > 65535) {
            throw new IllegalArgumentException("invalid extra field length");
        }
        this.entries = new LinkedHashMap<Short, ExtraData>();
        for (int index = 0; index < buffer.length; index += extra.getLength()) {
            extra = new ExtraData(buffer, index);
            this.entries.put(extra.getId(), extra);
        }
    }

    public ExtraData get(short id) {
        return this.entries.get(id);
    }

    public int getLength() {
        int length = 0;
        for (ExtraData e : this.entries.values()) {
            length += e.getLength();
        }
        return length;
    }
}

