/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.zip;

import com.facebook.presto.druid.DataInputSource;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.zip.ZipFileData;
import com.facebook.presto.druid.zip.ZipUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Preconditions;
import java.io.IOException;

public class Zip64EndOfCentralDirectory {
    static final int SIGNATURE = 101075792;
    static final int FIXED_DATA_SIZE = 56;
    static final int TOTAL_ENTRIES_OFFSET = 32;
    static final int CD_OFFSET_OFFSET = 48;

    private Zip64EndOfCentralDirectory() {
    }

    public static void read(ZipFileData file, DataInputSource dataInputSource, long offset) throws IOException {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (String)"Zip file data for source:%s is null", (Object)dataInputSource.getId());
        byte[] fixedSizeData = new byte[56];
        dataInputSource.readFully(offset, fixedSizeData);
        if (!ZipUtil.arrayStartsWith(fixedSizeData, ZipUtil.intToLittleEndian(101075792))) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, String.format("Malformed End of Central Directory Record; does not start with %08x", 101075792));
        }
        file.setZip64(true);
        file.setCentralDirectoryOffset(ZipUtil.getUnsignedLong(fixedSizeData, 48));
        file.setExpectedEntries(ZipUtil.getUnsignedLong(fixedSizeData, 32));
    }
}

