/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.zip;

import com.facebook.presto.druid.DataInputSource;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.zip.CentralDirectoryFileHeader;
import com.facebook.presto.druid.zip.EndOfCentralDirectoryRecord;
import com.facebook.presto.druid.zip.Zip64EndOfCentralDirectory;
import com.facebook.presto.druid.zip.Zip64EndOfCentralDirectoryLocator;
import com.facebook.presto.druid.zip.ZipFileEntry;
import com.facebook.presto.druid.zip.ZipUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipException;
import javax.annotation.Nullable;

public class ZipFileData {
    private final Charset charset;
    private final Map<String, ZipFileEntry> entries;
    private String comment;
    private long centralDirectorySize;
    private long centralDirectoryOffset;
    private long expectedEntries;
    private long numEntries;
    private boolean maybeZip64;
    private boolean isZip64;
    private long zip64EndOfCentralDirectoryOffset;

    public ZipFileData(Charset charset) {
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Zip file charset could not be null");
        this.charset = charset;
        this.comment = "";
        this.entries = new LinkedHashMap<String, ZipFileEntry>();
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(byte[] comment) {
        Preconditions.checkArgument((comment != null ? 1 : 0) != 0, (Object)"Zip file comment could not be null");
        if (comment.length > 65535) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, String.format("File comment too long. Is %d; max %d.", comment.length, 65535));
        }
        this.comment = this.fromBytes(comment);
    }

    public void setComment(String comment) {
        this.setComment(this.getBytes(comment));
    }

    public long getCentralDirectorySize() {
        return this.centralDirectorySize;
    }

    public void setCentralDirectorySize(long centralDirectorySize) {
        this.centralDirectorySize = centralDirectorySize;
        if (centralDirectorySize > 0xFFFFFFFFL) {
            this.setZip64(true);
        }
    }

    public long getCentralDirectoryOffset() {
        return this.centralDirectoryOffset;
    }

    public void setCentralDirectoryOffset(long offset) {
        this.centralDirectoryOffset = offset;
        if (this.centralDirectoryOffset > 0xFFFFFFFFL) {
            this.setZip64(true);
        }
    }

    public long getExpectedEntries() {
        return this.expectedEntries;
    }

    public void setExpectedEntries(long count) {
        this.expectedEntries = count;
        if (this.expectedEntries > 65535L) {
            this.setZip64(true);
        }
    }

    public long getNumEntries() {
        return this.numEntries;
    }

    private void setNumEntries(long numEntries) {
        this.numEntries = numEntries;
        if (numEntries > 65535L) {
            this.setZip64(true);
        }
    }

    public Collection<ZipFileEntry> getEntries() {
        return this.entries.values();
    }

    public ZipFileEntry getEntry(@Nullable String name) {
        return this.entries.get(name);
    }

    public void addEntry(ZipFileEntry entry) {
        this.entries.put(entry.getName(), entry);
        this.setNumEntries(this.numEntries + 1L);
        if (entry.getFeatureSet().contains((Object)ZipFileEntry.Feature.ZIP64_SIZE) || entry.getFeatureSet().contains((Object)ZipFileEntry.Feature.ZIP64_CSIZE) || entry.getFeatureSet().contains((Object)ZipFileEntry.Feature.ZIP64_OFFSET)) {
            this.setZip64(true);
        }
    }

    public boolean isMaybeZip64() {
        return this.maybeZip64;
    }

    public void setMaybeZip64(boolean maybeZip64) {
        this.maybeZip64 = maybeZip64;
    }

    public boolean isZip64() {
        return this.isZip64;
    }

    public void setZip64(boolean isZip64) {
        this.isZip64 = isZip64;
        this.setMaybeZip64(true);
    }

    public long getZip64EndOfCentralDirectoryOffset() {
        return this.zip64EndOfCentralDirectoryOffset;
    }

    public void setZip64EndOfCentralDirectoryOffset(long offset) {
        this.zip64EndOfCentralDirectoryOffset = offset;
        this.setZip64(true);
    }

    public byte[] getBytes(String string) {
        return string.getBytes(this.charset);
    }

    public String fromBytes(byte[] bytes) {
        return new String(bytes, this.charset);
    }

    public ZipFileData createZipFileData(DataInputSource dataInputSource) throws IOException {
        long eocdLocation = this.findEndOfCentralDirectoryRecord(dataInputSource);
        ZipFileData fileData = new ZipFileData(StandardCharsets.UTF_8);
        EndOfCentralDirectoryRecord.read(fileData, dataInputSource, eocdLocation);
        if (fileData.isMaybeZip64()) {
            try {
                Zip64EndOfCentralDirectoryLocator.read(fileData, dataInputSource, eocdLocation - 20L);
                Zip64EndOfCentralDirectory.read(fileData, dataInputSource, fileData.getZip64EndOfCentralDirectoryOffset());
            }
            catch (ZipException zipException) {
                // empty catch block
            }
        }
        if (fileData.isZip64()) {
            this.readCentralDirectoryFileHeaders(fileData, dataInputSource, fileData.getCentralDirectoryOffset(), fileData.getCharset(), fileData.getExpectedEntries());
        } else {
            long centralDirectoryOffset = eocdLocation - fileData.getCentralDirectorySize();
            if ((int)centralDirectoryOffset == (int)fileData.getCentralDirectoryOffset()) {
                this.readCentralDirectoryFileHeaders(fileData, dataInputSource, centralDirectoryOffset, fileData.getCharset());
            } else {
                this.readCentralDirectoryFileHeaders(fileData, dataInputSource, fileData.getCentralDirectoryOffset(), fileData.getCharset(), fileData.getExpectedEntries());
            }
        }
        return fileData;
    }

    private long findEndOfCentralDirectoryRecord(DataInputSource dataInputSource) throws IOException {
        long fileSize = dataInputSource.getSize();
        byte[] signature = ZipUtil.intToLittleEndian(101010256);
        byte[] buffer = new byte[(int)Math.min(64L, fileSize)];
        int readLength = buffer.length;
        if (readLength < 22) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, String.format("Zip file '%s' is malformed. It does not contain an end of central directory record.", dataInputSource.getId()));
        }
        for (long offset = fileSize - (long)buffer.length; offset >= 0L; offset -= (long)readLength) {
            dataInputSource.readFully(offset, buffer, 0, readLength);
            int signatureLocation = this.scanBackwards(signature, buffer, buffer.length);
            while (signatureLocation != -1) {
                long readCommentLength;
                int commentLength;
                long eocdSize = fileSize - offset - (long)signatureLocation;
                if (eocdSize >= 22L && (long)(commentLength = ZipUtil.getUnsignedShort(buffer, signatureLocation + 20)) == (readCommentLength = eocdSize - 22L)) {
                    return offset + (long)signatureLocation;
                }
                signatureLocation = this.scanBackwards(signature, buffer, signatureLocation - 1);
            }
            readLength = buffer.length - 3;
            buffer[buffer.length - 3] = buffer[0];
            buffer[buffer.length - 2] = buffer[1];
            buffer[buffer.length - 1] = buffer[2];
        }
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, String.format("Zip file '%s' is malformed. It does not contain an end of central directory record.", dataInputSource.getId()));
    }

    private void readCentralDirectoryFileHeaders(ZipFileData fileData, DataInputSource dataInputSource, long fileOffset, Charset charset, long count) throws IOException {
        try {
            long position = fileOffset;
            for (long i = 0L; i < count; ++i) {
                position += CentralDirectoryFileHeader.read(fileData, dataInputSource, position, charset);
            }
        }
        catch (ZipException e) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, (Throwable)e);
        }
    }

    private void readCentralDirectoryFileHeaders(ZipFileData fileData, DataInputSource dataInputSource, long fileOffset, Charset charset) throws IOException {
        try {
            long position = fileOffset;
            while (position - fileOffset < fileData.getCentralDirectorySize()) {
                position += CentralDirectoryFileHeader.read(fileData, dataInputSource, position, charset);
            }
        }
        catch (ZipException e) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, (Throwable)e);
        }
    }

    private int scanBackwards(byte[] target, byte[] buffer, int offset) {
        int start;
        for (int i = start = Math.min(offset, buffer.length - target.length); i >= 0; --i) {
            for (int j = 0; j < target.length && buffer[i + j] == target[j]; ++j) {
                if (j != target.length - 1) continue;
                return i;
            }
        }
        return -1;
    }
}

