/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.orc.FlushReason;
import com.facebook.presto.orc.OrcWriterFlushPolicy;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import java.util.Objects;
import java.util.Optional;

public class DefaultOrcWriterFlushPolicy
implements OrcWriterFlushPolicy {
    public static final DataSize DEFAULT_STRIPE_MIN_SIZE = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    public static final DataSize DEFAULT_STRIPE_MAX_SIZE = new DataSize(64.0, DataSize.Unit.MEGABYTE);
    public static final int DEFAULT_STRIPE_MAX_ROW_COUNT = 10000000;
    private final int stripeMaxRowCount;
    private final int stripeMinBytes;
    private final int stripeMaxBytes;

    private DefaultOrcWriterFlushPolicy(int stripeMaxRowCount, int stripeMinBytes, int stripeMaxBytes) {
        this.stripeMaxRowCount = stripeMaxRowCount;
        this.stripeMinBytes = stripeMinBytes;
        this.stripeMaxBytes = stripeMaxBytes;
    }

    @Override
    public Optional<FlushReason> shouldFlushStripe(int stripeRowCount, int bufferedBytes, boolean dictionaryIsFull) {
        if (stripeRowCount == this.stripeMaxRowCount) {
            return Optional.of(FlushReason.MAX_ROWS);
        }
        if (bufferedBytes > this.stripeMaxBytes) {
            return Optional.of(FlushReason.MAX_BYTES);
        }
        if (dictionaryIsFull) {
            return Optional.of(FlushReason.DICTIONARY_FULL);
        }
        return Optional.empty();
    }

    @Override
    public int getMaxChunkRowCount(Page page) {
        int chunkMaxLogicalBytes = Math.max(1, this.stripeMaxBytes / 2);
        double averageLogicalSizePerRow = (double)page.getApproximateLogicalSizeInBytes() / (double)page.getPositionCount();
        return Math.max(1, (int)((double)chunkMaxLogicalBytes / Math.max(1.0, averageLogicalSizePerRow)));
    }

    @Override
    public int getStripeMinBytes() {
        return this.stripeMinBytes;
    }

    @Override
    public int getStripeMaxBytes() {
        return this.stripeMaxBytes;
    }

    @Override
    public int getStripeMaxRowCount() {
        return this.stripeMaxRowCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stripeMaxRowCount", this.stripeMaxRowCount).add("stripeMinBytes", this.stripeMinBytes).add("stripeMaxBytes", this.stripeMaxBytes).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int stripeMaxRowCount = 10000000;
        private DataSize stripeMinSize = DEFAULT_STRIPE_MIN_SIZE;
        private DataSize stripeMaxSize = DEFAULT_STRIPE_MAX_SIZE;

        private Builder() {
        }

        public Builder withStripeMaxRowCount(int stripeMaxRowCount) {
            Preconditions.checkArgument((stripeMaxRowCount >= 1 ? 1 : 0) != 0, (Object)"stripeMaxRowCount must be at least 1");
            this.stripeMaxRowCount = stripeMaxRowCount;
            return this;
        }

        public Builder withStripeMinSize(DataSize stripeMinSize) {
            this.stripeMinSize = Objects.requireNonNull(stripeMinSize, "stripeMinSize is null");
            return this;
        }

        public Builder withStripeMaxSize(DataSize stripeMaxSize) {
            this.stripeMaxSize = Objects.requireNonNull(stripeMaxSize, "stripeMaxSize is null");
            return this;
        }

        public DefaultOrcWriterFlushPolicy build() {
            Preconditions.checkArgument((this.stripeMaxSize.compareTo(this.stripeMinSize) >= 0 ? 1 : 0) != 0, (Object)"stripeMaxSize must be greater than stripeMinSize");
            return new DefaultOrcWriterFlushPolicy(this.stripeMaxRowCount, Math.toIntExact(this.stripeMinSize.toBytes()), Math.toIntExact(this.stripeMaxSize.toBytes()));
        }
    }
}

