/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import io.airlift.slice.SizeOf;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.openjdk.jol.info.ClassLayout;

public interface CompressionBufferPool {
    public byte[] checkOut(int var1);

    public void checkIn(byte[] var1);

    public long getRetainedBytes();

    @NotThreadSafe
    public static class LastUsedCompressionBufferPool
    implements CompressionBufferPool {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(LastUsedCompressionBufferPool.class).instanceSize();
        private byte[] lastUsed;

        @Override
        public byte[] checkOut(int length) {
            if (this.lastUsed == null || this.lastUsed.length < length) {
                this.lastUsed = null;
                return new byte[length];
            }
            byte[] returnValue = this.lastUsed;
            this.lastUsed = null;
            return returnValue;
        }

        @Override
        public void checkIn(byte[] buffer) {
            this.lastUsed = Objects.requireNonNull(buffer, "buffer is null");
        }

        @Override
        public long getRetainedBytes() {
            return (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.lastUsed);
        }
    }
}

