/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.ColumnarRow;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.checkpoint.BooleanStreamCheckpoint;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressedMetadataWriter;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.stream.PresentOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class StructColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(StructColumnWriter.class).instanceSize();
    private static final ColumnEncoding COLUMN_ENCODING = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0);
    private final int column;
    private final int sequence;
    private final boolean compressed;
    private final PresentOutputStream presentStream;
    private final CompressedMetadataWriter metadataWriter;
    private final List<ColumnWriter> structFields;
    private final List<ColumnStatistics> rowGroupColumnStatistics = new ArrayList<ColumnStatistics>();
    private long columnStatisticsRetainedSizeInBytes;
    private int nonNullValueCount;
    private boolean closed;

    public StructColumnWriter(int column, int sequence, ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor, List<ColumnWriter> structFields, MetadataWriter metadataWriter) {
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"column is negative");
        Preconditions.checkArgument((sequence >= 0 ? 1 : 0) != 0, (Object)"sequence is negative");
        Objects.requireNonNull(columnWriterOptions, "columnWriterOptions is null");
        this.column = column;
        this.sequence = sequence;
        this.compressed = columnWriterOptions.getCompressionKind() != CompressionKind.NONE;
        this.structFields = ImmutableList.copyOf((Collection)Objects.requireNonNull(structFields, "structFields is null"));
        this.presentStream = new PresentOutputStream(columnWriterOptions, dwrfEncryptor);
        this.metadataWriter = new CompressedMetadataWriter(metadataWriter, columnWriterOptions, dwrfEncryptor);
    }

    @Override
    public List<ColumnWriter> getNestedColumnWriters() {
        ImmutableList.Builder nestedColumnWriters = ImmutableList.builder();
        for (ColumnWriter structField : this.structFields) {
            nestedColumnWriters.add((Object)structField).addAll(structField.getNestedColumnWriters());
        }
        return nestedColumnWriters.build();
    }

    @Override
    public Map<Integer, ColumnEncoding> getColumnEncodings() {
        ImmutableMap.Builder encodings = ImmutableMap.builder();
        encodings.put((Object)this.column, (Object)COLUMN_ENCODING);
        this.structFields.stream().map(ColumnWriter::getColumnEncodings).forEach(arg_0 -> ((ImmutableMap.Builder)encodings).putAll(arg_0));
        return encodings.build();
    }

    @Override
    public void beginRowGroup() {
        this.presentStream.recordCheckpoint();
        this.structFields.forEach(ColumnWriter::beginRowGroup);
    }

    @Override
    public long writeBlock(Block block) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)block);
        return this.writeColumnarRow(columnarRow);
    }

    private long writeColumnarRow(ColumnarRow columnarRow) {
        int blockNonNullValueCount = 0;
        for (int position = 0; position < columnarRow.getPositionCount(); ++position) {
            boolean present = !columnarRow.isNull(position);
            this.presentStream.writeBoolean(present);
            if (!present) continue;
            ++blockNonNullValueCount;
        }
        long childRawSize = 0L;
        for (int i = 0; i < this.structFields.size(); ++i) {
            ColumnWriter columnWriter = this.structFields.get(i);
            Block fieldBlock = columnarRow.getField(i);
            if (fieldBlock.getPositionCount() <= 0) continue;
            childRawSize += columnWriter.writeBlock(fieldBlock);
        }
        this.nonNullValueCount += blockNonNullValueCount;
        return (long)(columnarRow.getPositionCount() - blockNonNullValueCount) * 1L + childRawSize;
    }

    @Override
    public Map<Integer, ColumnStatistics> finishRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ColumnStatistics statistics = new ColumnStatistics(Long.valueOf(this.nonNullValueCount), null);
        this.rowGroupColumnStatistics.add(statistics);
        this.columnStatisticsRetainedSizeInBytes += statistics.getRetainedSizeInBytes();
        this.nonNullValueCount = 0;
        ImmutableMap.Builder columnStatistics = ImmutableMap.builder();
        columnStatistics.put((Object)this.column, (Object)statistics);
        this.structFields.stream().map(ColumnWriter::finishRowGroup).forEach(arg_0 -> ((ImmutableMap.Builder)columnStatistics).putAll(arg_0));
        return columnStatistics.build();
    }

    @Override
    public void close() {
        this.closed = true;
        this.structFields.forEach(ColumnWriter::close);
        this.presentStream.close();
    }

    @Override
    public Map<Integer, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        ImmutableMap.Builder columnStatistics = ImmutableMap.builder();
        columnStatistics.put((Object)this.column, (Object)ColumnStatistics.mergeColumnStatistics(this.rowGroupColumnStatistics));
        this.structFields.stream().map(ColumnWriter::getColumnStripeStatistics).forEach(arg_0 -> ((ImmutableMap.Builder)columnStatistics).putAll(arg_0));
        return columnStatistics.build();
    }

    @Override
    public List<StreamDataOutput> getIndexStreams() throws IOException {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder rowGroupIndexes = ImmutableList.builder();
        Optional<List<BooleanStreamCheckpoint>> presentCheckpoints = this.presentStream.getCheckpoints();
        int i = 0;
        while (i < this.rowGroupColumnStatistics.size()) {
            int groupId = i++;
            ColumnStatistics columnStatistics = this.rowGroupColumnStatistics.get(groupId);
            Optional<BooleanStreamCheckpoint> presentCheckpoint = presentCheckpoints.map(checkpoints -> (BooleanStreamCheckpoint)checkpoints.get(groupId));
            List<Integer> positions = StructColumnWriter.createStructColumnPositionList(this.compressed, presentCheckpoint);
            rowGroupIndexes.add((Object)new RowGroupIndex(positions, columnStatistics));
        }
        Slice slice = this.metadataWriter.writeRowIndexes((List<RowGroupIndex>)rowGroupIndexes.build());
        Stream stream = new Stream(this.column, this.sequence, Stream.StreamKind.ROW_INDEX, slice.length(), false);
        ImmutableList.Builder indexStreams = ImmutableList.builder();
        indexStreams.add((Object)new StreamDataOutput(slice, stream));
        for (ColumnWriter structField : this.structFields) {
            indexStreams.addAll(structField.getIndexStreams());
        }
        return indexStreams.build();
    }

    private static List<Integer> createStructColumnPositionList(boolean compressed, Optional<BooleanStreamCheckpoint> presentCheckpoint) {
        ImmutableList.Builder positionList = ImmutableList.builder();
        presentCheckpoint.ifPresent(booleanStreamCheckpoint -> positionList.addAll(booleanStreamCheckpoint.toPositionList(compressed)));
        return positionList.build();
    }

    @Override
    public List<StreamDataOutput> getDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        this.presentStream.getStreamDataOutput(this.column, this.sequence).ifPresent(arg_0 -> ((ImmutableList.Builder)outputDataStreams).add(arg_0));
        for (ColumnWriter structField : this.structFields) {
            outputDataStreams.addAll(structField.getDataStreams());
        }
        return outputDataStreams.build();
    }

    @Override
    public long getBufferedBytes() {
        long bufferedBytes = this.presentStream.getBufferedBytes();
        for (ColumnWriter structField : this.structFields) {
            bufferedBytes += structField.getBufferedBytes();
        }
        return bufferedBytes;
    }

    @Override
    public long getRetainedBytes() {
        long retainedBytes = (long)INSTANCE_SIZE + this.presentStream.getRetainedBytes();
        for (ColumnWriter structField : this.structFields) {
            retainedBytes += structField.getRetainedBytes();
        }
        return retainedBytes += this.columnStatisticsRetainedSizeInBytes;
    }

    @Override
    public void reset() {
        this.closed = false;
        this.presentStream.reset();
        this.structFields.forEach(ColumnWriter::reset);
        this.rowGroupColumnStatistics.clear();
        this.columnStatisticsRetainedSizeInBytes = 0L;
        this.nonNullValueCount = 0;
    }
}

