/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.zstd;

import com.github.luben.zstd.Zstd;
import io.airlift.compress.Compressor;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.OptionalInt;

public class ZstdJniCompressor
implements Compressor {
    private static final int DEFAULT_COMPRESSION_LEVEL = 3;
    private final int compressionLevel;

    public ZstdJniCompressor(OptionalInt compressionLevel) {
        Objects.requireNonNull(compressionLevel, "compressionLevel is null");
        this.compressionLevel = compressionLevel.orElse(3);
    }

    public int maxCompressedLength(int uncompressedSize) {
        return Math.toIntExact(Zstd.compressBound((long)uncompressedSize));
    }

    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        long size = Zstd.compressByteArray((byte[])output, (int)outputOffset, (int)maxOutputLength, (byte[])input, (int)inputOffset, (int)inputLength, (int)this.compressionLevel);
        if (Zstd.isError((long)size)) {
            throw new RuntimeException(Zstd.getErrorName((long)size));
        }
        return Math.toIntExact(size);
    }

    public void compress(ByteBuffer input, ByteBuffer output) {
        if (input.isDirect() || output.isDirect() || !input.hasArray() || !output.hasArray()) {
            throw new IllegalArgumentException("Non-direct byte buffer backed by byte array required");
        }
        int inputOffset = input.arrayOffset() + input.position();
        int outputOffset = output.arrayOffset() + output.position();
        int written = this.compress(input.array(), inputOffset, input.remaining(), output.array(), outputOffset, output.remaining());
        output.position(output.position() + written);
    }
}

