/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullValueHandlingConfig;

public class NullHandling {
    public static final Double ZERO_DOUBLE = 0.0;
    public static final Float ZERO_FLOAT = Float.valueOf(0.0f);
    public static final Long ZERO_LONG = 0L;
    public static final byte IS_NULL_BYTE = 1;
    public static final byte IS_NOT_NULL_BYTE = 0;
    @Inject
    private static NullValueHandlingConfig INSTANCE;

    @VisibleForTesting
    public static void initializeForTests() {
        INSTANCE = new NullValueHandlingConfig(null);
    }

    public static boolean replaceWithDefault() {
        if (INSTANCE == null) {
            throw new IllegalStateException("NullHandling module not initialized, call NullHandling.initializeForTests()");
        }
        return INSTANCE.isUseDefaultValuesForNull();
    }

    public static boolean sqlCompatible() {
        return !NullHandling.replaceWithDefault();
    }

    @Nullable
    public static String nullToEmptyIfNeeded(@Nullable String value) {
        return NullHandling.replaceWithDefault() ? Strings.nullToEmpty((String)value) : value;
    }

    @Nullable
    public static String emptyToNullIfNeeded(@Nullable String value) {
        return NullHandling.replaceWithDefault() ? Strings.emptyToNull((String)value) : value;
    }

    public static boolean needsEmptyToNull(@Nullable String value) {
        return NullHandling.replaceWithDefault() && Strings.isNullOrEmpty((String)value);
    }

    @Nullable
    public static String defaultStringValue() {
        return NullHandling.replaceWithDefault() ? "" : null;
    }

    @Nullable
    public static Long defaultLongValue() {
        return NullHandling.replaceWithDefault() ? ZERO_LONG : null;
    }

    @Nullable
    public static Float defaultFloatValue() {
        return NullHandling.replaceWithDefault() ? ZERO_FLOAT : null;
    }

    @Nullable
    public static Double defaultDoubleValue() {
        return NullHandling.replaceWithDefault() ? ZERO_DOUBLE : null;
    }

    @Nullable
    public static <T> T defaultValueForClass(Class<T> clazz) {
        if (clazz == Float.class) {
            return (T)NullHandling.defaultFloatValue();
        }
        if (clazz == Double.class) {
            return (T)NullHandling.defaultDoubleValue();
        }
        if (clazz == Long.class) {
            return (T)NullHandling.defaultLongValue();
        }
        if (clazz == Number.class) {
            return (T)NullHandling.defaultDoubleValue();
        }
        if (clazz == String.class) {
            return (T)NullHandling.defaultStringValue();
        }
        return null;
    }

    public static boolean isNullOrEquivalent(@Nullable String value) {
        return NullHandling.replaceWithDefault() ? Strings.isNullOrEmpty((String)value) : value == null;
    }
}

