/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.crypto;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.annotation.Nullable;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.druid.java.util.common.StringUtils;

public class CryptoService {
    private static final SecureRandom SECURE_RANDOM_INSTANCE = new SecureRandom();
    private final char[] passPhrase;
    private final String secretKeyFactoryAlg;
    private final int saltSize;
    private final int iterationCount;
    private final int keyLength;
    private final String cipherAlgName;
    private final String cipherAlgMode;
    private final String cipherAlgPadding;
    private final String transformation;

    public CryptoService(String passPhrase, @Nullable String cipherAlgName, @Nullable String cipherAlgMode, @Nullable String cipherAlgPadding, @Nullable String secretKeyFactoryAlg, @Nullable Integer saltSize, @Nullable Integer iterationCount, @Nullable Integer keyLength) {
        Preconditions.checkArgument((passPhrase != null && !passPhrase.isEmpty() ? 1 : 0) != 0, (Object)"null/empty passPhrase");
        this.passPhrase = passPhrase.toCharArray();
        this.cipherAlgName = cipherAlgName == null ? "AES" : cipherAlgName;
        this.cipherAlgMode = cipherAlgMode == null ? "CBC" : cipherAlgMode;
        this.cipherAlgPadding = cipherAlgPadding == null ? "PKCS5Padding" : cipherAlgPadding;
        this.transformation = StringUtils.format("%s/%s/%s", this.cipherAlgName, this.cipherAlgMode, this.cipherAlgPadding);
        this.secretKeyFactoryAlg = secretKeyFactoryAlg == null ? "PBKDF2WithHmacSHA256" : secretKeyFactoryAlg;
        this.saltSize = saltSize == null ? 8 : saltSize;
        this.iterationCount = iterationCount == null ? 65536 : iterationCount;
        this.keyLength = keyLength == null ? 128 : keyLength;
        String testString = "duh! !! !!!";
        Preconditions.checkState((boolean)testString.equals(StringUtils.fromUtf8(this.decrypt(this.encrypt(StringUtils.toUtf8(testString))))), (Object)"decrypt(encrypt(testString)) failed");
    }

    public byte[] encrypt(byte[] plain) {
        try {
            byte[] salt = new byte[this.saltSize];
            SECURE_RANDOM_INSTANCE.nextBytes(salt);
            SecretKey tmp = this.getKeyFromPassword(this.passPhrase, salt);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), this.cipherAlgName);
            Cipher ecipher = Cipher.getInstance(this.transformation);
            ecipher.init(1, secret);
            return new EncryptedData(salt, ecipher.getParameters().getParameterSpec(IvParameterSpec.class).getIV(), ecipher.doFinal(plain)).toByteAray();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | InvalidParameterSpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public byte[] decrypt(byte[] data) {
        try {
            EncryptedData encryptedData = EncryptedData.fromByteArray(data);
            SecretKey tmp = this.getKeyFromPassword(this.passPhrase, encryptedData.getSalt());
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), this.cipherAlgName);
            Cipher dcipher = Cipher.getInstance(this.transformation);
            dcipher.init(2, (Key)secret, new IvParameterSpec(encryptedData.getIv()));
            return dcipher.doFinal(encryptedData.getCipher());
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private SecretKey getKeyFromPassword(char[] passPhrase, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(this.secretKeyFactoryAlg);
        PBEKeySpec spec = new PBEKeySpec(passPhrase, salt, this.iterationCount, this.keyLength);
        return factory.generateSecret(spec);
    }

    private static class EncryptedData {
        private final byte[] salt;
        private final byte[] iv;
        private final byte[] cipher;

        public EncryptedData(byte[] salt, byte[] iv, byte[] cipher) {
            this.salt = salt;
            this.iv = iv;
            this.cipher = cipher;
        }

        public byte[] getSalt() {
            return this.salt;
        }

        public byte[] getIv() {
            return this.iv;
        }

        public byte[] getCipher() {
            return this.cipher;
        }

        public byte[] toByteAray() {
            int headerLength = 12;
            ByteBuffer bb = ByteBuffer.allocate(this.salt.length + this.iv.length + this.cipher.length + headerLength);
            bb.putInt(this.salt.length).putInt(this.iv.length).putInt(this.cipher.length).put(this.salt).put(this.iv).put(this.cipher);
            bb.flip();
            return bb.array();
        }

        public static EncryptedData fromByteArray(byte[] array) {
            ByteBuffer bb = ByteBuffer.wrap(array);
            int saltSize = bb.getInt();
            int ivSize = bb.getInt();
            int cipherSize = bb.getInt();
            byte[] salt = new byte[saltSize];
            bb.get(salt);
            byte[] iv = new byte[ivSize];
            bb.get(iv);
            byte[] cipher = new byte[cipherSize];
            bb.get(cipher);
            return new EncryptedData(salt, iv, cipher);
        }
    }
}

