/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.indexer.Checks;
import org.apache.druid.indexer.Property;

public abstract class FlatTextInputFormat
implements InputFormat {
    private final List<String> columns;
    private final String listDelimiter;
    private final String delimiter;
    private final boolean findColumnsFromHeader;
    private final int skipHeaderRows;

    FlatTextInputFormat(@Nullable List<String> columns, @Nullable String listDelimiter, String delimiter, @Nullable Boolean hasHeaderRow, @Nullable Boolean findColumnsFromHeader, int skipHeaderRows) {
        this.columns = columns == null ? Collections.emptyList() : columns;
        this.listDelimiter = listDelimiter;
        this.delimiter = (String)Preconditions.checkNotNull((Object)delimiter, (Object)"delimiter");
        this.findColumnsFromHeader = columns == null || columns.isEmpty() ? (Boolean)Checks.checkOneNotNullOrEmpty(ImmutableList.of(new Property<Boolean>("hasHeaderRow", hasHeaderRow), new Property<Boolean>("findColumnsFromHeader", findColumnsFromHeader))).getValue() : (findColumnsFromHeader == null ? false : findColumnsFromHeader);
        this.skipHeaderRows = skipHeaderRows;
        Preconditions.checkArgument((!delimiter.equals(listDelimiter) ? 1 : 0) != 0, (String)"Cannot have same delimiter and list delimiter of [%s]", (Object[])new Object[]{delimiter});
        if (!this.columns.isEmpty()) {
            for (String column : this.columns) {
                Preconditions.checkArgument((!column.contains(delimiter) ? 1 : 0) != 0, (String)("Column[%s] cannot have the delimiter[" + delimiter + "] in its name"), (Object[])new Object[]{column});
            }
        } else {
            Preconditions.checkArgument((boolean)this.findColumnsFromHeader, (Object)"If columns field is not set, the first row of your data must have your header and hasHeaderRow must be set to true.");
        }
    }

    @JsonProperty
    public String getDelimiter() {
        return this.delimiter;
    }

    @JsonProperty
    public List<String> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public String getListDelimiter() {
        return this.listDelimiter;
    }

    @JsonProperty
    public boolean isFindColumnsFromHeader() {
        return this.findColumnsFromHeader;
    }

    @JsonProperty
    public int getSkipHeaderRows() {
        return this.skipHeaderRows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlatTextInputFormat that = (FlatTextInputFormat)o;
        return this.findColumnsFromHeader == that.findColumnsFromHeader && this.skipHeaderRows == that.skipHeaderRows && Objects.equals(this.listDelimiter, that.listDelimiter) && Objects.equals(this.columns, that.columns) && Objects.equals(this.delimiter, that.delimiter);
    }

    public int hashCode() {
        return Objects.hash(this.listDelimiter, this.columns, this.findColumnsFromHeader, this.skipHeaderRows, this.delimiter);
    }
}

