/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.JsonReader;
import org.apache.druid.data.input.impl.NestedInputFormat;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;

public class JsonInputFormat
extends NestedInputFormat {
    private final Map<String, Boolean> featureSpec;
    private final ObjectMapper objectMapper;
    private final boolean keepNullColumns;

    @JsonCreator
    public JsonInputFormat(@JsonProperty(value="flattenSpec") @Nullable JSONPathSpec flattenSpec, @JsonProperty(value="featureSpec") @Nullable Map<String, Boolean> featureSpec, @JsonProperty(value="keepNullColumns") @Nullable Boolean keepNullColumns) {
        super(flattenSpec);
        this.featureSpec = featureSpec == null ? Collections.emptyMap() : featureSpec;
        this.objectMapper = new ObjectMapper();
        this.keepNullColumns = keepNullColumns == null ? false : keepNullColumns;
        for (Map.Entry<String, Boolean> entry : this.featureSpec.entrySet()) {
            JsonParser.Feature feature = JsonParser.Feature.valueOf((String)entry.getKey());
            this.objectMapper.configure(feature, entry.getValue().booleanValue());
        }
    }

    @JsonProperty
    public Map<String, Boolean> getFeatureSpec() {
        return this.featureSpec;
    }

    @Override
    public boolean isSplittable() {
        return false;
    }

    @Override
    public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory) {
        return new JsonReader(inputRowSchema, source, this.getFlattenSpec(), this.objectMapper, this.keepNullColumns);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonInputFormat that = (JsonInputFormat)o;
        return Objects.equals(this.featureSpec, that.featureSpec) && Objects.equals(this.keepNullColumns, that.keepNullColumns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.featureSpec, this.keepNullColumns);
    }
}

