/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.joda.time.DateTime;

public class MapInputRowParser
implements InputRowParser<Map<String, Object>> {
    private final ParseSpec parseSpec;
    private final List<String> dimensions;

    @JsonCreator
    public MapInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec) {
        this.parseSpec = parseSpec;
        this.dimensions = parseSpec.getDimensionsSpec().getDimensionNames();
    }

    @Override
    public List<InputRow> parseBatch(Map<String, Object> theMap) {
        return ImmutableList.of((Object)MapInputRowParser.parse(this.parseSpec.getTimestampSpec(), this.dimensions, this.parseSpec.getDimensionsSpec().getDimensionExclusions(), theMap));
    }

    public static InputRow parse(InputRowSchema inputRowSchema, Map<String, Object> theMap) throws ParseException {
        return MapInputRowParser.parse(inputRowSchema.getTimestampSpec(), inputRowSchema.getDimensionsSpec(), theMap);
    }

    public static InputRow parse(TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, Map<String, Object> theMap) throws ParseException {
        return MapInputRowParser.parse(timestampSpec, dimensionsSpec.getDimensionNames(), dimensionsSpec.getDimensionExclusions(), theMap);
    }

    public static InputRow parse(TimestampSpec timestampSpec, List<String> dimensions, Set<String> dimensionExclusions, Map<String, Object> theMap) throws ParseException {
        DateTime timestamp;
        List<String> dimensionsToUse = !dimensions.isEmpty() ? dimensions : new ArrayList<String>((Collection<String>)Sets.difference(theMap.keySet(), dimensionExclusions));
        try {
            timestamp = timestampSpec.extractTimestamp(theMap);
            if (timestamp == null) {
                String input = theMap.toString();
                throw new NullPointerException(StringUtils.format("Null timestamp in input: %s", input.length() < 100 ? input : input.substring(0, 100) + "..."));
            }
        }
        catch (Exception e) {
            throw new ParseException(e, "Unparseable timestamp found! Event: %s", theMap);
        }
        return new MapBasedInputRow(timestamp, dimensionsToUse, theMap);
    }

    @Override
    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    @Override
    public InputRowParser withParseSpec(ParseSpec parseSpec) {
        return new MapInputRowParser(parseSpec);
    }
}

