/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.partitions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import javax.annotation.Nullable;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.SecondaryPartitionType;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=HashedPartitionsSpec.class)
@JsonSubTypes(value={@JsonSubTypes.Type(name="single_dim", value=SingleDimensionPartitionsSpec.class), @JsonSubTypes.Type(name="dimension", value=SingleDimensionPartitionsSpec.class), @JsonSubTypes.Type(name="hashed", value=HashedPartitionsSpec.class), @JsonSubTypes.Type(name="dynamic", value=DynamicPartitionsSpec.class)})
public interface PartitionsSpec {
    public static final int DEFAULT_MAX_ROWS_PER_SEGMENT = 5000000;
    public static final String MAX_ROWS_PER_SEGMENT = "maxRowsPerSegment";
    public static final int HISTORICAL_NULL = -1;

    @JsonIgnore
    public SecondaryPartitionType getType();

    @Nullable
    public Integer getMaxRowsPerSegment();

    public boolean needsDeterminePartitions(boolean var1);

    @JsonIgnore
    default public boolean isForceGuaranteedRollupCompatibleType() {
        return !(this instanceof DynamicPartitionsSpec);
    }

    @JsonIgnore
    default public boolean isForceGuaranteedRollupCompatible() {
        return this.getForceGuaranteedRollupIncompatiblityReason().isEmpty();
    }

    @JsonIgnore
    public String getForceGuaranteedRollupIncompatiblityReason();

    public static boolean isEffectivelyNull(@Nullable Integer val) {
        return val == null || val == -1;
    }

    public static boolean isEffectivelyNull(@Nullable Long val) {
        return val == null || val == -1L;
    }

    @Nullable
    public static Integer resolveHistoricalNullIfNeeded(@Nullable Integer val) {
        return PartitionsSpec.isEffectivelyNull(val) ? null : val;
    }
}

