/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.parsers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.java.util.common.parsers.Parser;
import org.apache.druid.java.util.common.parsers.ParserUtils;

@Deprecated
public class JSONToLowerParser
implements Parser<String, Object> {
    private static final Function<JsonNode, Object> VALUE_FUNCTION = new Function<JsonNode, Object>(){

        public Object apply(JsonNode node) {
            if (node == null || node.isMissingNode() || node.isNull()) {
                return null;
            }
            if (node.isIntegralNumber()) {
                if (node.canConvertToLong()) {
                    return node.asLong();
                }
                return node.asDouble();
            }
            if (node.isFloatingPointNumber()) {
                return node.asDouble();
            }
            String s = node.asText();
            CharsetEncoder enc = StandardCharsets.UTF_8.newEncoder();
            if (s != null && !enc.canEncode(s)) {
                return StringUtils.fromUtf8(StringUtils.toUtf8(s));
            }
            return s;
        }
    };
    private final ObjectMapper objectMapper;
    private final Set<String> exclude;
    private ArrayList<String> fieldNames;

    public JSONToLowerParser(ObjectMapper objectMapper, Iterable<String> fieldNames, Iterable<String> exclude) {
        this.objectMapper = objectMapper;
        if (fieldNames != null) {
            this.setFieldNames(fieldNames);
        }
        this.exclude = exclude != null ? Sets.newHashSet((Iterable)Iterables.transform(exclude, StringUtils::toLowerCase)) : new HashSet();
    }

    @Override
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public void setFieldNames(Iterable<String> fieldNames) {
        ParserUtils.validateFields(fieldNames);
        this.fieldNames = Lists.newArrayList(fieldNames);
    }

    @Override
    public Map<String, Object> parseToMap(String input) {
        try {
            Iterator<String> keysIter;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            JsonNode root = this.objectMapper.readTree(input);
            Iterator<String> iterator = keysIter = this.fieldNames == null ? root.fieldNames() : this.fieldNames.iterator();
            while (keysIter.hasNext()) {
                Object nodeValue;
                String key = keysIter.next();
                if (this.exclude.contains(StringUtils.toLowerCase(key))) continue;
                JsonNode node = root.path(key);
                if (node.isArray()) {
                    nodeValue = Lists.newArrayListWithExpectedSize((int)node.size());
                    for (JsonNode subnode : node) {
                        Object subnodeValue = VALUE_FUNCTION.apply((Object)subnode);
                        if (subnodeValue == null) continue;
                        nodeValue.add(subnodeValue);
                    }
                    map.put(StringUtils.toLowerCase(key), nodeValue);
                    continue;
                }
                nodeValue = VALUE_FUNCTION.apply((Object)node);
                if (nodeValue == null) continue;
                map.put(StringUtils.toLowerCase(key), nodeValue);
            }
            return map;
        }
        catch (Exception e) {
            throw new ParseException(e, "Unable to parse row [%s]", input);
        }
    }
}

