/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.core.LoggingEmitterConfig;

public class LoggingEmitter
implements Emitter {
    private final Logger log;
    private final Level level;
    private final ObjectMapper jsonMapper;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public LoggingEmitter(LoggingEmitterConfig config, ObjectMapper jsonMapper) {
        this(new Logger(config.getLoggerClass()), Level.toLevel(config.getLogLevel()), jsonMapper);
    }

    public LoggingEmitter(Logger log, Level level, ObjectMapper jsonMapper) {
        this.log = log;
        this.level = level;
        this.jsonMapper = jsonMapper;
    }

    @Override
    @LifecycleStart
    public void start() {
        boolean alreadyStarted = this.started.getAndSet(true);
        if (!alreadyStarted) {
            String message = "Start: started [%s]";
            switch (this.level) {
                case TRACE: {
                    if (!this.log.isTraceEnabled()) break;
                    this.log.trace("Start: started [%s]", this.started.get());
                    break;
                }
                case DEBUG: {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Start: started [%s]", this.started.get());
                    break;
                }
                case INFO: {
                    if (!this.log.isInfoEnabled()) break;
                    this.log.info("Start: started [%s]", this.started.get());
                    break;
                }
                case WARN: {
                    this.log.warn("Start: started [%s]", this.started.get());
                    break;
                }
                case ERROR: {
                    this.log.error("Start: started [%s]", this.started.get());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emit(Event event) {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (!this.started.get()) {
                throw new RejectedExecutionException("Service not started.");
            }
        }
        try {
            switch (this.level) {
                case TRACE: {
                    if (!this.log.isTraceEnabled()) break;
                    this.log.trace(this.jsonMapper.writeValueAsString((Object)event), new Object[0]);
                    break;
                }
                case DEBUG: {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug(this.jsonMapper.writeValueAsString((Object)event), new Object[0]);
                    break;
                }
                case INFO: {
                    if (!this.log.isInfoEnabled()) break;
                    this.log.info(this.jsonMapper.writeValueAsString((Object)event), new Object[0]);
                    break;
                }
                case WARN: {
                    this.log.warn(this.jsonMapper.writeValueAsString((Object)event), new Object[0]);
                    break;
                }
                case ERROR: {
                    this.log.error(this.jsonMapper.writeValueAsString((Object)event), new Object[0]);
                }
            }
        }
        catch (Exception e) {
            this.log.warn(e, "Failed to generate json", new Object[0]);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    @LifecycleStop
    public void close() {
        boolean wasStarted = this.started.getAndSet(false);
        if (wasStarted) {
            String message = "Close: started [%s]";
            switch (this.level) {
                case TRACE: {
                    if (!this.log.isTraceEnabled()) break;
                    this.log.trace("Close: started [%s]", this.started.get());
                    break;
                }
                case DEBUG: {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Close: started [%s]", this.started.get());
                    break;
                }
                case INFO: {
                    if (!this.log.isInfoEnabled()) break;
                    this.log.info("Close: started [%s]", this.started.get());
                    break;
                }
                case WARN: {
                    this.log.warn("Close: started [%s]", this.started.get());
                    break;
                }
                case ERROR: {
                    this.log.error("Close: started [%s]", this.started.get());
                }
            }
        }
    }

    public String toString() {
        return "LoggingEmitter{log=" + this.log + ", level=" + (Object)((Object)this.level) + '}';
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;


        public static Level toLevel(String name) {
            return Level.valueOf(StringUtils.toUpperCase(name));
        }
    }
}

