/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.CartesianList;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.Function;
import org.apache.druid.math.expr.LambdaExpr;

public interface ApplyFunction {
    public String name();

    public ExprEval apply(LambdaExpr var1, List<Expr> var2, Expr.ObjectBinding var3);

    public Set<Expr> getArrayInputs(List<Expr> var1);

    default public boolean hasArrayOutput(LambdaExpr lambdaExpr) {
        return false;
    }

    public void validateArguments(LambdaExpr var1, List<Expr> var2);

    public static class CartesianFoldLambdaBinding
    implements IndexableFoldLambdaBinding {
        private final Expr.ObjectBinding bindings;
        private final Object2IntMap<String> lambdaIdentifiers;
        private final List<List<Object>> lambdaInputs;
        private final String accumulatorIdentifier;
        private Object accumulatorValue;
        private int index = 0;

        CartesianFoldLambdaBinding(List<List<Object>> inputs, Object accumulatorValue, LambdaExpr expr, Expr.ObjectBinding bindings) {
            this.lambdaInputs = inputs;
            List<String> ids = expr.getIdentifiers();
            this.lambdaIdentifiers = new Object2IntArrayMap(ids.size());
            for (int i = 0; i < ids.size() - 1; ++i) {
                this.lambdaIdentifiers.put((Object)ids.get(i), i);
            }
            this.accumulatorIdentifier = ids.get(ids.size() - 1);
            this.bindings = bindings != null ? bindings : Collections.emptyMap()::get;
            this.accumulatorValue = accumulatorValue;
        }

        @Override
        @Nullable
        public Object get(String name) {
            if (this.lambdaIdentifiers.containsKey((Object)name)) {
                return this.lambdaInputs.get(this.index).get(this.lambdaIdentifiers.getInt((Object)name));
            }
            if (this.accumulatorIdentifier.equals(name)) {
                return this.accumulatorValue;
            }
            return this.bindings.get(name);
        }

        @Override
        public int getLength() {
            return this.lambdaInputs.size();
        }

        @Override
        public CartesianFoldLambdaBinding accumulateWithIndex(int index, Object acc) {
            this.index = index;
            this.accumulatorValue = acc;
            return this;
        }
    }

    public static class FoldLambdaBinding
    implements IndexableFoldLambdaBinding {
        private final Expr.ObjectBinding bindings;
        private final String elementIdentifier;
        private final Object[] arrayValues;
        private final String accumulatorIdentifier;
        private Object accumulatorValue;
        private int index;

        FoldLambdaBinding(Object[] arrayValues, Object initialAccumulator, LambdaExpr expr, Expr.ObjectBinding bindings) {
            List<String> ids = expr.getIdentifiers();
            this.elementIdentifier = ids.get(0);
            this.accumulatorIdentifier = ids.get(1);
            this.arrayValues = arrayValues;
            this.accumulatorValue = initialAccumulator;
            this.bindings = bindings != null ? bindings : Collections.emptyMap()::get;
        }

        @Override
        @Nullable
        public Object get(String name) {
            if (name.equals(this.elementIdentifier)) {
                return this.arrayValues[this.index];
            }
            if (name.equals(this.accumulatorIdentifier)) {
                return this.accumulatorValue;
            }
            return this.bindings.get(name);
        }

        @Override
        public int getLength() {
            return this.arrayValues.length;
        }

        @Override
        public FoldLambdaBinding accumulateWithIndex(int index, Object acc) {
            this.index = index;
            this.accumulatorValue = acc;
            return this;
        }
    }

    public static interface IndexableFoldLambdaBinding
    extends Expr.ObjectBinding {
        public int getLength();

        public IndexableFoldLambdaBinding accumulateWithIndex(int var1, Object var2);
    }

    public static class CartesianMapLambdaBinding
    implements IndexableMapLambdaObjectBinding {
        private final Expr.ObjectBinding bindings;
        private final Object2IntMap<String> lambdaIdentifiers;
        private final List<List<Object>> lambdaInputs;
        private final boolean scoped;
        private int index = 0;

        CartesianMapLambdaBinding(List<List<Object>> inputs, LambdaExpr expr, Expr.ObjectBinding bindings) {
            this.lambdaInputs = inputs;
            List<String> ids = expr.getIdentifiers();
            this.scoped = ids.size() > 0;
            this.lambdaIdentifiers = new Object2IntArrayMap(ids.size());
            for (int i = 0; i < ids.size(); ++i) {
                this.lambdaIdentifiers.put((Object)ids.get(i), i);
            }
            this.bindings = bindings != null ? bindings : Collections.emptyMap()::get;
        }

        @Override
        @Nullable
        public Object get(String name) {
            if (this.scoped && this.lambdaIdentifiers.containsKey((Object)name)) {
                return this.lambdaInputs.get(this.index).get(this.lambdaIdentifiers.getInt((Object)name));
            }
            return this.bindings.get(name);
        }

        @Override
        public int getLength() {
            return this.lambdaInputs.size();
        }

        @Override
        public CartesianMapLambdaBinding withIndex(int index) {
            this.index = index;
            return this;
        }
    }

    public static class MapLambdaBinding
    implements IndexableMapLambdaObjectBinding {
        private final Expr.ObjectBinding bindings;
        @Nullable
        private final String lambdaIdentifier;
        private final Object[] arrayValues;
        private int index = 0;
        private final boolean scoped;

        MapLambdaBinding(Object[] arrayValues, LambdaExpr expr, Expr.ObjectBinding bindings) {
            this.lambdaIdentifier = expr.getIdentifier();
            this.arrayValues = arrayValues;
            this.bindings = bindings != null ? bindings : Collections.emptyMap()::get;
            this.scoped = this.lambdaIdentifier != null;
        }

        @Override
        @Nullable
        public Object get(String name) {
            if (this.scoped && name.equals(this.lambdaIdentifier)) {
                return this.arrayValues[this.index];
            }
            return this.bindings.get(name);
        }

        @Override
        public int getLength() {
            return this.arrayValues.length;
        }

        @Override
        public MapLambdaBinding withIndex(int index) {
            this.index = index;
            return this;
        }
    }

    public static interface IndexableMapLambdaObjectBinding
    extends Expr.ObjectBinding {
        public int getLength();

        public IndexableMapLambdaObjectBinding withIndex(int var1);
    }

    public static class SettableLambdaBinding
    implements Expr.ObjectBinding {
        private final Expr.ObjectBinding bindings;
        private final Map<String, Object> lambdaBindings = new HashMap<String, Object>();

        SettableLambdaBinding(LambdaExpr expr, Expr.ObjectBinding bindings) {
            for (String lambdaIdentifier : expr.getIdentifiers()) {
                this.lambdaBindings.put(lambdaIdentifier, null);
            }
            this.bindings = bindings != null ? bindings : Collections.emptyMap()::get;
        }

        @Override
        @Nullable
        public Object get(String name) {
            if (this.lambdaBindings.containsKey(name)) {
                return this.lambdaBindings.get(name);
            }
            return this.bindings.get(name);
        }

        SettableLambdaBinding withBinding(String key, Object value) {
            this.lambdaBindings.put(key, value);
            return this;
        }
    }

    public static class AllMatchFunction
    extends MatchFunction {
        static final String NAME = "all";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public ExprEval match(Object[] values, LambdaExpr expr, SettableLambdaBinding bindings) {
            boolean allMatch = Arrays.stream(values).allMatch(o -> expr.eval(bindings.withBinding(expr.getIdentifier(), o)).asBoolean());
            return ExprEval.of(allMatch, ExprType.LONG);
        }
    }

    public static class AnyMatchFunction
    extends MatchFunction {
        static final String NAME = "any";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public ExprEval match(Object[] values, LambdaExpr expr, SettableLambdaBinding bindings) {
            boolean anyMatch = Arrays.stream(values).anyMatch(o -> expr.eval(bindings.withBinding(expr.getIdentifier(), o)).asBoolean());
            return ExprEval.of(anyMatch, ExprType.LONG);
        }
    }

    public static abstract class MatchFunction
    implements ApplyFunction {
        @Override
        public ExprEval apply(LambdaExpr lambdaExpr, List<Expr> argsExpr, Expr.ObjectBinding bindings) {
            Expr arrayExpr = argsExpr.get(0);
            ExprEval arrayEval = arrayExpr.eval(bindings);
            Object[] array = arrayEval.asArray();
            if (array == null) {
                return ExprEval.of(false, ExprType.LONG);
            }
            SettableLambdaBinding lambdaBinding = new SettableLambdaBinding(lambdaExpr, bindings);
            return this.match(array, lambdaExpr, lambdaBinding);
        }

        @Override
        public Set<Expr> getArrayInputs(List<Expr> args) {
            if (args.size() != 1) {
                throw new IAE("ApplyFunction[%s] needs 1 argument", this.name());
            }
            return ImmutableSet.of((Object)args.get(0));
        }

        @Override
        public void validateArguments(LambdaExpr lambdaExpr, List<Expr> args) {
            Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0);
            Preconditions.checkArgument((args.size() == lambdaExpr.identifierCount() ? 1 : 0) != 0, (Object)StringUtils.format("lambda expression argument count does not match %s argument count", this.name()));
        }

        public abstract ExprEval match(Object[] var1, LambdaExpr var2, SettableLambdaBinding var3);
    }

    public static class FilterFunction
    implements ApplyFunction {
        static final String NAME = "filter";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public boolean hasArrayOutput(LambdaExpr lambdaExpr) {
            return true;
        }

        @Override
        public ExprEval apply(LambdaExpr lambdaExpr, List<Expr> argsExpr, Expr.ObjectBinding bindings) {
            Expr arrayExpr = argsExpr.get(0);
            ExprEval arrayEval = arrayExpr.eval(bindings);
            Object[] array = arrayEval.asArray();
            if (array == null) {
                return ExprEval.of(null);
            }
            SettableLambdaBinding lambdaBinding = new SettableLambdaBinding(lambdaExpr, bindings);
            switch (arrayEval.type()) {
                case STRING: 
                case STRING_ARRAY: {
                    String[] filteredString = (String[])this.filter(arrayEval.asStringArray(), lambdaExpr, lambdaBinding).toArray(String[]::new);
                    return ExprEval.ofStringArray(filteredString);
                }
                case LONG: 
                case LONG_ARRAY: {
                    Long[] filteredLong = (Long[])this.filter(arrayEval.asLongArray(), lambdaExpr, lambdaBinding).toArray(Long[]::new);
                    return ExprEval.ofLongArray(filteredLong);
                }
                case DOUBLE: 
                case DOUBLE_ARRAY: {
                    Double[] filteredDouble = (Double[])this.filter(arrayEval.asDoubleArray(), lambdaExpr, lambdaBinding).toArray(Double[]::new);
                    return ExprEval.ofDoubleArray(filteredDouble);
                }
            }
            throw new RE("Unhandled filter function input type [%s]", new Object[]{arrayEval.type()});
        }

        @Override
        public Set<Expr> getArrayInputs(List<Expr> args) {
            if (args.size() != 1) {
                throw new IAE("ApplyFunction[%s] needs 1 argument", this.name());
            }
            return ImmutableSet.of((Object)args.get(0));
        }

        @Override
        public void validateArguments(LambdaExpr lambdaExpr, List<Expr> args) {
            Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0);
            Preconditions.checkArgument((args.size() == lambdaExpr.identifierCount() ? 1 : 0) != 0, (Object)StringUtils.format("lambda expression argument count does not match %s argument count", this.name()));
        }

        private <T> Stream<T> filter(T[] array, LambdaExpr expr, SettableLambdaBinding binding) {
            return Arrays.stream(array).filter(s -> expr.eval(binding.withBinding(expr.getIdentifier(), s)).asBoolean());
        }
    }

    public static class CartesianFoldFunction
    extends BaseFoldFunction {
        static final String NAME = "cartesian_fold";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public ExprEval apply(LambdaExpr lambdaExpr, List<Expr> argsExpr, Expr.ObjectBinding bindings) {
            ArrayList<List<Object>> arrayInputs = new ArrayList<List<Object>>();
            boolean hadNull = false;
            boolean hadEmpty = false;
            for (int i = 0; i < argsExpr.size() - 1; ++i) {
                Expr expr = argsExpr.get(i);
                ExprEval arrayEval = expr.eval(bindings);
                Object[] array = arrayEval.asArray();
                if (array == null) {
                    hadNull = true;
                    continue;
                }
                if (array.length == 0) {
                    hadEmpty = true;
                    continue;
                }
                arrayInputs.add(Arrays.asList(array));
            }
            if (hadNull) {
                return ExprEval.of(null);
            }
            if (hadEmpty) {
                return ExprEval.ofStringArray(new String[0]);
            }
            Expr accExpr = argsExpr.get(argsExpr.size() - 1);
            List<List<Object>> product = CartesianList.create(arrayInputs);
            ExprEval accEval = accExpr.eval(bindings);
            Object accumulator = accEval.value();
            CartesianFoldLambdaBinding lambdaBindings = new CartesianFoldLambdaBinding(product, accumulator, lambdaExpr, bindings);
            return this.applyFold(lambdaExpr, accumulator, lambdaBindings);
        }

        @Override
        public Set<Expr> getArrayInputs(List<Expr> args) {
            return ImmutableSet.copyOf(args.subList(0, args.size() - 1));
        }

        @Override
        public void validateArguments(LambdaExpr lambdaExpr, List<Expr> args) {
            Preconditions.checkArgument((args.size() == lambdaExpr.identifierCount() ? 1 : 0) != 0, (Object)StringUtils.format("lambda expression argument count does not match %s argument count", this.name()));
        }
    }

    public static class FoldFunction
    extends BaseFoldFunction {
        static final String NAME = "fold";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public ExprEval apply(LambdaExpr lambdaExpr, List<Expr> argsExpr, Expr.ObjectBinding bindings) {
            Expr arrayExpr = argsExpr.get(0);
            Expr accExpr = argsExpr.get(1);
            ExprEval arrayEval = arrayExpr.eval(bindings);
            ExprEval accEval = accExpr.eval(bindings);
            Object[] array = arrayEval.asArray();
            if (array == null) {
                return ExprEval.of(null);
            }
            Object accumulator = accEval.value();
            FoldLambdaBinding lambdaBinding = new FoldLambdaBinding(array, accumulator, lambdaExpr, bindings);
            return this.applyFold(lambdaExpr, accumulator, lambdaBinding);
        }

        @Override
        public Set<Expr> getArrayInputs(List<Expr> args) {
            return ImmutableSet.of((Object)args.get(0));
        }

        @Override
        public void validateArguments(LambdaExpr lambdaExpr, List<Expr> args) {
            Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0);
            Preconditions.checkArgument((args.size() == lambdaExpr.identifierCount() ? 1 : 0) != 0, (Object)StringUtils.format("lambda expression argument count does not match %s argument count", this.name()));
        }
    }

    public static abstract class BaseFoldFunction
    implements ApplyFunction {
        ExprEval applyFold(LambdaExpr lambdaExpr, Object accumulator, IndexableFoldLambdaBinding bindings) {
            for (int i = 0; i < bindings.getLength(); ++i) {
                ExprEval evaluated = lambdaExpr.eval(bindings.accumulateWithIndex(i, accumulator));
                accumulator = evaluated.value();
            }
            if (accumulator instanceof Boolean) {
                return ExprEval.of((Boolean)accumulator, ExprType.LONG);
            }
            return ExprEval.bestEffortOf(accumulator);
        }

        @Override
        public boolean hasArrayOutput(LambdaExpr lambdaExpr) {
            Expr.BindingDetails lambdaBindingDetails = lambdaExpr.analyzeInputs();
            return lambdaBindingDetails.isOutputArray();
        }
    }

    public static class CartesianMapFunction
    extends BaseMapFunction {
        static final String NAME = "cartesian_map";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public ExprEval apply(LambdaExpr lambdaExpr, List<Expr> argsExpr, Expr.ObjectBinding bindings) {
            ArrayList<List<Object>> arrayInputs = new ArrayList<List<Object>>();
            boolean hadNull = false;
            boolean hadEmpty = false;
            for (Expr expr : argsExpr) {
                ExprEval arrayEval = expr.eval(bindings);
                Object[] array = arrayEval.asArray();
                if (array == null) {
                    hadNull = true;
                    continue;
                }
                if (array.length == 0) {
                    hadEmpty = true;
                    continue;
                }
                arrayInputs.add(Arrays.asList(array));
            }
            if (hadNull) {
                return ExprEval.of(null);
            }
            if (hadEmpty) {
                return ExprEval.ofStringArray(new String[0]);
            }
            List<List<Object>> product = CartesianList.create(arrayInputs);
            CartesianMapLambdaBinding lambdaBinding = new CartesianMapLambdaBinding(product, lambdaExpr, bindings);
            return this.applyMap(lambdaExpr, lambdaBinding);
        }

        @Override
        public Set<Expr> getArrayInputs(List<Expr> args) {
            return ImmutableSet.copyOf(args);
        }

        @Override
        public void validateArguments(LambdaExpr lambdaExpr, List<Expr> args) {
            Preconditions.checkArgument((args.size() > 0 ? 1 : 0) != 0);
            if (lambdaExpr.identifierCount() > 0) {
                Preconditions.checkArgument((args.size() == lambdaExpr.identifierCount() ? 1 : 0) != 0, (Object)StringUtils.format("lambda expression argument count does not match %s argument count", this.name()));
            }
        }
    }

    public static class MapFunction
    extends BaseMapFunction {
        static final String NAME = "map";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public ExprEval apply(LambdaExpr lambdaExpr, List<Expr> argsExpr, Expr.ObjectBinding bindings) {
            Expr arrayExpr = argsExpr.get(0);
            ExprEval arrayEval = arrayExpr.eval(bindings);
            Object[] array = arrayEval.asArray();
            if (array == null) {
                return ExprEval.of(null);
            }
            if (array.length == 0) {
                return arrayEval;
            }
            MapLambdaBinding lambdaBinding = new MapLambdaBinding(array, lambdaExpr, bindings);
            return this.applyMap(lambdaExpr, lambdaBinding);
        }

        @Override
        public Set<Expr> getArrayInputs(List<Expr> args) {
            if (args.size() == 1) {
                return ImmutableSet.of((Object)args.get(0));
            }
            return Collections.emptySet();
        }

        @Override
        public void validateArguments(LambdaExpr lambdaExpr, List<Expr> args) {
            Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0);
            if (lambdaExpr.identifierCount() > 0) {
                Preconditions.checkArgument((args.size() == lambdaExpr.identifierCount() ? 1 : 0) != 0, (Object)StringUtils.format("lambda expression argument count does not match %s argument count", this.name()));
            }
        }
    }

    public static abstract class BaseMapFunction
    implements ApplyFunction {
        @Override
        public boolean hasArrayOutput(LambdaExpr lambdaExpr) {
            return true;
        }

        ExprEval applyMap(LambdaExpr expr, IndexableMapLambdaObjectBinding bindings) {
            int length = bindings.getLength();
            String[] stringsOut = null;
            Long[] longsOut = null;
            Double[] doublesOut = null;
            Enum elementType = null;
            for (int i = 0; i < length; ++i) {
                ExprEval evaluated = expr.eval(bindings.withIndex(i));
                if (elementType == null) {
                    elementType = evaluated.type();
                    switch (1.$SwitchMap$org$apache$druid$math$expr$ExprType[elementType.ordinal()]) {
                        case 1: {
                            stringsOut = new String[length];
                            break;
                        }
                        case 2: {
                            longsOut = new Long[length];
                            break;
                        }
                        case 3: {
                            doublesOut = new Double[length];
                            break;
                        }
                        default: {
                            throw new RE("Unhandled map function output type [%s]", elementType);
                        }
                    }
                }
                Function.ArrayConstructorFunction.setArrayOutputElement(stringsOut, longsOut, doublesOut, (ExprType)elementType, i, evaluated);
            }
            switch (1.$SwitchMap$org$apache$druid$math$expr$ExprType[elementType.ordinal()]) {
                case 1: {
                    return ExprEval.ofStringArray(stringsOut);
                }
                case 2: {
                    return ExprEval.ofLongArray(longsOut);
                }
                case 3: {
                    return ExprEval.ofDoubleArray(doublesOut);
                }
            }
            throw new RE("Unhandled map function output type [%s]", elementType);
        }
    }
}

