/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;

abstract class BinaryOpExprBase
implements Expr {
    protected final String op;
    protected final Expr left;
    protected final Expr right;

    BinaryOpExprBase(String op, Expr left, Expr right) {
        this.op = op;
        this.left = left;
        this.right = right;
    }

    @Override
    public void visit(Expr.Visitor visitor) {
        this.left.visit(visitor);
        this.right.visit(visitor);
        visitor.visit(this);
    }

    @Override
    public Expr visit(Expr.Shuttle shuttle) {
        Expr newLeft = this.left.visit(shuttle);
        Expr newRight = this.right.visit(shuttle);
        if (this.left != newLeft || this.right != newRight) {
            return shuttle.visit(this.copy(newLeft, newRight));
        }
        return shuttle.visit(this);
    }

    public String toString() {
        return StringUtils.format("(%s %s %s)", this.op, this.left, this.right);
    }

    @Override
    public String stringify() {
        return StringUtils.format("(%s %s %s)", this.left.stringify(), this.op, this.right.stringify());
    }

    protected abstract BinaryOpExprBase copy(Expr var1, Expr var2);

    @Override
    public Expr.BindingDetails analyzeInputs() {
        return this.left.analyzeInputs().with(this.right).withScalarArguments((Set<Expr>)ImmutableSet.of((Object)this.left, (Object)this.right));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryOpExprBase that = (BinaryOpExprBase)o;
        return Objects.equals(this.op, that.op) && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    public int hashCode() {
        return Objects.hash(this.op, this.left, this.right);
    }
}

