/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.primitives.Doubles;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.math.expr.DoubleArrayExpr;
import org.apache.druid.math.expr.DoubleExpr;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.LongArrayExpr;
import org.apache.druid.math.expr.LongExpr;
import org.apache.druid.math.expr.NullDoubleExpr;
import org.apache.druid.math.expr.NullLongExpr;
import org.apache.druid.math.expr.StringArrayExpr;
import org.apache.druid.math.expr.StringExpr;

public abstract class ExprEval<T> {
    private boolean stringValueCached = false;
    @Nullable
    private String stringValue;
    @Nullable
    final T value;

    public static ExprEval ofLong(@Nullable Number longValue) {
        return new LongExprEval(longValue);
    }

    public static ExprEval of(long longValue) {
        return new LongExprEval(longValue);
    }

    public static ExprEval ofDouble(@Nullable Number doubleValue) {
        return new DoubleExprEval(doubleValue);
    }

    public static ExprEval of(double doubleValue) {
        return new DoubleExprEval(doubleValue);
    }

    public static ExprEval of(@Nullable String stringValue) {
        if (stringValue == null) {
            return StringExprEval.OF_NULL;
        }
        return new StringExprEval(stringValue);
    }

    public static ExprEval ofLongArray(@Nullable Long[] longValue) {
        return new LongArrayExprEval(longValue);
    }

    public static ExprEval ofDoubleArray(@Nullable Double[] doubleValue) {
        return new DoubleArrayExprEval(doubleValue);
    }

    public static ExprEval ofStringArray(@Nullable String[] stringValue) {
        return new StringArrayExprEval(stringValue);
    }

    public static ExprEval of(boolean value, ExprType type) {
        switch (type) {
            case DOUBLE: {
                return ExprEval.of(Evals.asDouble(value));
            }
            case LONG: {
                return ExprEval.of(Evals.asLong(value));
            }
            case STRING: {
                return ExprEval.of(String.valueOf(value));
            }
        }
        throw new IllegalArgumentException("invalid type " + (Object)((Object)type));
    }

    public static ExprEval bestEffortOf(@Nullable Object val) {
        if (val instanceof ExprEval) {
            return (ExprEval)val;
        }
        if (val instanceof Number) {
            if (val instanceof Float || val instanceof Double) {
                return new DoubleExprEval((Number)val);
            }
            return new LongExprEval((Number)val);
        }
        if (val instanceof Long[]) {
            return new LongArrayExprEval((Long[])val);
        }
        if (val instanceof Double[]) {
            return new DoubleArrayExprEval((Double[])val);
        }
        if (val instanceof Float[]) {
            return new DoubleArrayExprEval((Double[])Arrays.stream((Float[])val).map(Float::doubleValue).toArray(Double[]::new));
        }
        if (val instanceof String[]) {
            return new StringArrayExprEval((String[])val);
        }
        return new StringExprEval(val == null ? null : String.valueOf(val));
    }

    private ExprEval(@Nullable T value) {
        this.value = value;
    }

    public abstract ExprType type();

    @Nullable
    public T value() {
        return this.value;
    }

    void cacheStringValue(@Nullable String value) {
        this.stringValue = value;
        this.stringValueCached = true;
    }

    @Nullable
    String getCachedStringValue() {
        assert (this.stringValueCached);
        return this.stringValue;
    }

    boolean isStringValueCached() {
        return this.stringValueCached;
    }

    @Nullable
    public String asString() {
        if (!this.stringValueCached) {
            this.stringValue = this.value == null ? null : String.valueOf(this.value);
            this.stringValueCached = true;
        }
        return this.stringValue;
    }

    public abstract boolean isNumericNull();

    public boolean isArray() {
        return false;
    }

    public abstract int asInt();

    public abstract long asLong();

    public abstract double asDouble();

    public abstract boolean asBoolean();

    @Nullable
    public abstract Object[] asArray();

    @Nullable
    public abstract String[] asStringArray();

    @Nullable
    public abstract Long[] asLongArray();

    @Nullable
    public abstract Double[] asDoubleArray();

    public abstract ExprEval castTo(ExprType var1);

    public abstract Expr toExpr();

    private static class StringArrayExprEval
    extends ArrayExprEval<String> {
        private boolean longValueValid = false;
        private boolean doubleValueValid = false;
        private Long[] longValues;
        private Double[] doubleValues;

        private StringArrayExprEval(@Nullable String[] value) {
            super(value);
        }

        @Override
        public ExprType type() {
            return ExprType.STRING_ARRAY;
        }

        @Override
        @Nullable
        public String[] asStringArray() {
            return (String[])this.value;
        }

        @Override
        @Nullable
        public Long[] asLongArray() {
            if (!this.longValueValid) {
                this.longValues = this.computeLongs();
                this.longValueValid = true;
            }
            return this.longValues;
        }

        @Override
        @Nullable
        public Double[] asDoubleArray() {
            if (!this.doubleValueValid) {
                this.doubleValues = this.computeDoubles();
                this.doubleValueValid = true;
            }
            return this.doubleValues;
        }

        @Override
        public ExprEval castTo(ExprType castTo) {
            if (this.value == null) {
                return StringExprEval.OF_NULL;
            }
            switch (castTo) {
                case STRING_ARRAY: {
                    return this;
                }
                case LONG_ARRAY: {
                    return ExprEval.ofLongArray(this.asLongArray());
                }
                case DOUBLE_ARRAY: {
                    return ExprEval.ofDoubleArray(this.asDoubleArray());
                }
            }
            throw new IAE("invalid type " + (Object)((Object)castTo), new Object[0]);
        }

        @Override
        public Expr toExpr() {
            return new StringArrayExpr((String[])this.value);
        }

        @Nullable
        private Long[] computeLongs() {
            if (this.value == null) {
                return null;
            }
            return (Long[])Arrays.stream((Object[])this.value).map(value -> {
                Double d;
                Long lv = GuavaUtils.tryParseLong(value);
                if (lv == null && (d = Doubles.tryParse((String)value)) != null) {
                    lv = d.longValue();
                }
                return lv;
            }).toArray(Long[]::new);
        }

        @Nullable
        private Double[] computeDoubles() {
            if (this.value == null) {
                return null;
            }
            return (Double[])Arrays.stream((Object[])this.value).map(Doubles::tryParse).toArray(Double[]::new);
        }
    }

    private static class DoubleArrayExprEval
    extends ArrayExprEval<Double> {
        private DoubleArrayExprEval(@Nullable Double[] value) {
            super(value);
        }

        @Override
        public ExprType type() {
            return ExprType.DOUBLE_ARRAY;
        }

        @Override
        @Nullable
        public String[] asStringArray() {
            return this.value == null ? null : (String[])Arrays.stream((Object[])this.value).map(x -> x != null ? x.toString() : null).toArray(String[]::new);
        }

        @Override
        @Nullable
        public Long[] asLongArray() {
            return this.value == null ? null : (Long[])Arrays.stream((Object[])this.value).map(Double::longValue).toArray(Long[]::new);
        }

        @Override
        @Nullable
        public Double[] asDoubleArray() {
            return (Double[])this.value;
        }

        @Override
        public ExprEval castTo(ExprType castTo) {
            if (this.value == null) {
                return StringExprEval.OF_NULL;
            }
            switch (castTo) {
                case LONG_ARRAY: {
                    return ExprEval.ofLongArray(this.asLongArray());
                }
                case DOUBLE_ARRAY: {
                    return this;
                }
                case STRING_ARRAY: {
                    return ExprEval.ofStringArray(this.asStringArray());
                }
            }
            throw new IAE("invalid type " + (Object)((Object)castTo), new Object[0]);
        }

        @Override
        public Expr toExpr() {
            return new DoubleArrayExpr((Double[])this.value);
        }
    }

    private static class LongArrayExprEval
    extends ArrayExprEval<Long> {
        private LongArrayExprEval(@Nullable Long[] value) {
            super(value);
        }

        @Override
        public ExprType type() {
            return ExprType.LONG_ARRAY;
        }

        @Override
        @Nullable
        public String[] asStringArray() {
            return this.value == null ? null : (String[])Arrays.stream((Object[])this.value).map(x -> x != null ? x.toString() : null).toArray(String[]::new);
        }

        @Override
        @Nullable
        public Long[] asLongArray() {
            return (Long[])this.value;
        }

        @Override
        @Nullable
        public Double[] asDoubleArray() {
            return this.value == null ? null : (Double[])Arrays.stream((Object[])this.value).map(Long::doubleValue).toArray(Double[]::new);
        }

        @Override
        public ExprEval castTo(ExprType castTo) {
            if (this.value == null) {
                return StringExprEval.OF_NULL;
            }
            switch (castTo) {
                case LONG_ARRAY: {
                    return this;
                }
                case DOUBLE_ARRAY: {
                    return ExprEval.ofDoubleArray(this.asDoubleArray());
                }
                case STRING_ARRAY: {
                    return ExprEval.ofStringArray(this.asStringArray());
                }
            }
            throw new IAE("invalid type " + (Object)((Object)castTo), new Object[0]);
        }

        @Override
        public Expr toExpr() {
            return new LongArrayExpr((Long[])this.value);
        }
    }

    static abstract class ArrayExprEval<T>
    extends ExprEval<T[]> {
        private ArrayExprEval(@Nullable T[] value) {
            super(value);
        }

        @Override
        @Nullable
        public String asString() {
            if (!this.isStringValueCached()) {
                if (this.value == null) {
                    this.cacheStringValue(null);
                } else {
                    this.cacheStringValue(Arrays.toString((Object[])this.value));
                }
            }
            return this.getCachedStringValue();
        }

        @Override
        public boolean isNumericNull() {
            return false;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public int asInt() {
            return 0;
        }

        @Override
        public long asLong() {
            return 0L;
        }

        @Override
        public double asDouble() {
            return 0.0;
        }

        @Override
        public boolean asBoolean() {
            return false;
        }

        @Override
        @Nullable
        public T[] asArray() {
            return (Object[])this.value;
        }

        @Nullable
        public T getIndex(int index) {
            return (T)(this.value == null ? null : ((Object[])this.value)[index]);
        }
    }

    private static class StringExprEval
    extends ExprEval<String> {
        private boolean intValueValid = false;
        private boolean longValueValid = false;
        private boolean doubleValueValid = false;
        private boolean booleanValueValid = false;
        private int intValue;
        private long longValue;
        private double doubleValue;
        private boolean booleanValue;
        private static final StringExprEval OF_NULL = new StringExprEval(null);
        @Nullable
        private Number numericVal;

        private StringExprEval(@Nullable String value) {
            super(NullHandling.emptyToNullIfNeeded(value));
        }

        @Override
        public final ExprType type() {
            return ExprType.STRING;
        }

        @Override
        public int asInt() {
            if (!this.intValueValid) {
                this.intValue = this.computeInt();
                this.intValueValid = true;
            }
            return this.intValue;
        }

        @Override
        public long asLong() {
            if (!this.longValueValid) {
                this.longValue = this.computeLong();
                this.longValueValid = true;
            }
            return this.longValue;
        }

        @Override
        public double asDouble() {
            if (!this.doubleValueValid) {
                this.doubleValue = this.computeDouble();
                this.doubleValueValid = true;
            }
            return this.doubleValue;
        }

        @Override
        @Nullable
        public String asString() {
            return (String)this.value;
        }

        @Override
        @Nullable
        public Object[] asArray() {
            return this.asStringArray();
        }

        private int computeInt() {
            Number number = this.computeNumber();
            if (number == null) {
                assert (NullHandling.replaceWithDefault());
                return 0;
            }
            return number.intValue();
        }

        private long computeLong() {
            Number number = this.computeNumber();
            if (number == null) {
                assert (NullHandling.replaceWithDefault());
                return 0L;
            }
            return number.longValue();
        }

        private double computeDouble() {
            Number number = this.computeNumber();
            if (number == null) {
                assert (NullHandling.replaceWithDefault());
                return 0.0;
            }
            return number.doubleValue();
        }

        @Nullable
        private Number computeNumber() {
            if (this.value == null) {
                return null;
            }
            if (this.numericVal != null) {
                return this.numericVal;
            }
            Long v = GuavaUtils.tryParseLong((String)this.value);
            Number rv = v != null ? (Number)v : (Number)Doubles.tryParse((String)((String)this.value));
            this.numericVal = rv;
            return rv;
        }

        @Override
        public boolean isNumericNull() {
            return this.computeNumber() == null;
        }

        @Override
        public final boolean asBoolean() {
            if (!this.booleanValueValid) {
                this.booleanValue = Evals.asBoolean((String)this.value);
                this.booleanValueValid = true;
            }
            return this.booleanValue;
        }

        @Override
        @Nullable
        public String[] asStringArray() {
            String[] stringArray;
            if (this.value == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)this.value;
            }
            return stringArray;
        }

        @Override
        @Nullable
        public Long[] asLongArray() {
            Long[] longArray;
            if (this.value == null) {
                longArray = null;
            } else {
                Long[] longArray2 = new Long[1];
                longArray = longArray2;
                longArray2[0] = this.computeLong();
            }
            return longArray;
        }

        @Override
        @Nullable
        public Double[] asDoubleArray() {
            Double[] doubleArray;
            if (this.value == null) {
                doubleArray = null;
            } else {
                Double[] doubleArray2 = new Double[1];
                doubleArray = doubleArray2;
                doubleArray2[0] = this.computeDouble();
            }
            return doubleArray;
        }

        @Override
        public final ExprEval castTo(ExprType castTo) {
            switch (castTo) {
                case DOUBLE: {
                    return ExprEval.ofDouble(this.computeNumber());
                }
                case LONG: {
                    return ExprEval.ofLong(this.computeNumber());
                }
                case STRING: {
                    return this;
                }
                case DOUBLE_ARRAY: {
                    return ExprEval.ofDoubleArray(this.asDoubleArray());
                }
                case LONG_ARRAY: {
                    return ExprEval.ofLongArray(this.asLongArray());
                }
                case STRING_ARRAY: {
                    return ExprEval.ofStringArray(this.asStringArray());
                }
            }
            throw new IAE("invalid type " + (Object)((Object)castTo), new Object[0]);
        }

        @Override
        public Expr toExpr() {
            return new StringExpr((String)this.value);
        }
    }

    private static class LongExprEval
    extends NumericExprEval {
        private LongExprEval(@Nullable Number value) {
            super(value == null ? NullHandling.defaultLongValue() : Long.valueOf(value.longValue()));
        }

        @Override
        public final ExprType type() {
            return ExprType.LONG;
        }

        @Override
        public final boolean asBoolean() {
            return Evals.asBoolean(this.asLong());
        }

        @Override
        @Nullable
        public Object[] asArray() {
            return this.asLongArray();
        }

        @Override
        @Nullable
        public Long[] asLongArray() {
            Long[] longArray;
            if (this.isNumericNull()) {
                longArray = null;
            } else {
                Long[] longArray2 = new Long[1];
                longArray = longArray2;
                longArray2[0] = ((Number)this.value).longValue();
            }
            return longArray;
        }

        @Override
        public final ExprEval castTo(ExprType castTo) {
            switch (castTo) {
                case DOUBLE: {
                    if (this.value == null) {
                        return ExprEval.ofDouble(null);
                    }
                    return ExprEval.of(this.asDouble());
                }
                case LONG: {
                    return this;
                }
                case STRING: {
                    return ExprEval.of(this.asString());
                }
                case DOUBLE_ARRAY: {
                    return ExprEval.ofDoubleArray(this.asDoubleArray());
                }
                case LONG_ARRAY: {
                    return ExprEval.ofLongArray(this.asLongArray());
                }
                case STRING_ARRAY: {
                    return ExprEval.ofStringArray(this.asStringArray());
                }
            }
            throw new IAE("invalid type " + (Object)((Object)castTo), new Object[0]);
        }

        @Override
        public Expr toExpr() {
            if (this.isNumericNull()) {
                return new NullLongExpr();
            }
            return new LongExpr(((Number)this.value).longValue());
        }
    }

    private static class DoubleExprEval
    extends NumericExprEval {
        private DoubleExprEval(@Nullable Number value) {
            super(value == null ? NullHandling.defaultDoubleValue() : Double.valueOf(value.doubleValue()));
        }

        @Override
        public final ExprType type() {
            return ExprType.DOUBLE;
        }

        @Override
        public final boolean asBoolean() {
            return Evals.asBoolean(this.asDouble());
        }

        @Override
        @Nullable
        public Object[] asArray() {
            return this.asDoubleArray();
        }

        @Override
        public final ExprEval castTo(ExprType castTo) {
            switch (castTo) {
                case DOUBLE: {
                    return this;
                }
                case LONG: {
                    if (this.value == null) {
                        return ExprEval.ofLong(null);
                    }
                    return ExprEval.of(this.asLong());
                }
                case STRING: {
                    return ExprEval.of(this.asString());
                }
                case DOUBLE_ARRAY: {
                    return ExprEval.ofDoubleArray(this.asDoubleArray());
                }
                case LONG_ARRAY: {
                    return ExprEval.ofLongArray(this.asLongArray());
                }
                case STRING_ARRAY: {
                    return ExprEval.ofStringArray(this.asStringArray());
                }
            }
            throw new IAE("invalid type " + (Object)((Object)castTo), new Object[0]);
        }

        @Override
        public Expr toExpr() {
            if (this.isNumericNull()) {
                return new NullDoubleExpr();
            }
            return new DoubleExpr(((Number)this.value).doubleValue());
        }
    }

    private static abstract class NumericExprEval
    extends ExprEval<Number> {
        private NumericExprEval(@Nullable Number value) {
            super(value);
        }

        @Override
        public final int asInt() {
            return ((Number)this.value).intValue();
        }

        @Override
        public final long asLong() {
            return ((Number)this.value).longValue();
        }

        @Override
        public final double asDouble() {
            return ((Number)this.value).doubleValue();
        }

        @Override
        @Nullable
        public String[] asStringArray() {
            String[] stringArray;
            if (this.isNumericNull()) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ((Number)this.value).toString();
            }
            return stringArray;
        }

        @Override
        @Nullable
        public Long[] asLongArray() {
            Long[] longArray;
            if (this.isNumericNull()) {
                longArray = null;
            } else {
                Long[] longArray2 = new Long[1];
                longArray = longArray2;
                longArray2[0] = ((Number)this.value).longValue();
            }
            return longArray;
        }

        @Override
        @Nullable
        public Double[] asDoubleArray() {
            Double[] doubleArray;
            if (this.isNumericNull()) {
                doubleArray = null;
            } else {
                Double[] doubleArray2 = new Double[1];
                doubleArray = doubleArray2;
                doubleArray2[0] = ((Number)this.value).doubleValue();
            }
            return doubleArray;
        }

        @Override
        public boolean isNumericNull() {
            return this.value == null;
        }
    }
}

