/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.math.expr.ConstantExpr;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;

class LongExpr
extends ConstantExpr {
    private final Long value;

    LongExpr(Long value) {
        this.value = (Long)Preconditions.checkNotNull((Object)value, (Object)"value");
    }

    @Override
    public Object getLiteralValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return ExprEval.ofLong(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongExpr longExpr = (LongExpr)o;
        return Objects.equals(this.value, longExpr.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

