/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Properties;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.metadata.PasswordProvider;

public class MetadataStorageConnectorConfig {
    @JsonProperty
    private boolean createTables = true;
    @JsonProperty
    private String host = "localhost";
    @JsonProperty
    private int port = 1527;
    @JsonProperty
    private String connectURI;
    @JsonProperty
    private String user = null;
    @JsonProperty(value="password")
    private PasswordProvider passwordProvider;
    @JsonProperty(value="dbcp")
    private Properties dbcpProperties;

    public boolean isCreateTables() {
        return this.createTables;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public String getConnectURI() {
        if (this.connectURI == null) {
            return StringUtils.format("jdbc:derby://%s:%s/druid;create=true", this.host, this.port);
        }
        return this.connectURI;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.passwordProvider == null ? null : this.passwordProvider.getPassword();
    }

    public Properties getDbcpProperties() {
        return this.dbcpProperties;
    }

    public String toString() {
        return "DbConnectorConfig{createTables=" + this.createTables + ", connectURI='" + this.getConnectURI() + '\'' + ", user='" + this.user + '\'' + ", passwordProvider=" + this.passwordProvider + ", dbcpProperties=" + this.dbcpProperties + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetadataStorageConnectorConfig)) {
            return false;
        }
        MetadataStorageConnectorConfig that = (MetadataStorageConnectorConfig)o;
        if (this.isCreateTables() != that.isCreateTables()) {
            return false;
        }
        if (this.getPort() != that.getPort()) {
            return false;
        }
        if (this.getHost() != null ? !this.getHost().equals(that.getHost()) : that.getHost() != null) {
            return false;
        }
        if (this.getConnectURI() != null ? !this.getConnectURI().equals(that.getConnectURI()) : that.getConnectURI() != null) {
            return false;
        }
        if (this.getUser() != null ? !this.getUser().equals(that.getUser()) : that.getUser() != null) {
            return false;
        }
        if (this.getDbcpProperties() == null ? that.getDbcpProperties() != null : !this.getDbcpProperties().equals(that.getDbcpProperties())) {
            return false;
        }
        return this.passwordProvider != null ? this.passwordProvider.equals(that.passwordProvider) : that.passwordProvider == null;
    }

    public int hashCode() {
        int result = this.isCreateTables() ? 1 : 0;
        result = 31 * result + (this.getHost() != null ? this.getHost().hashCode() : 0);
        result = 31 * result + this.getPort();
        result = 31 * result + (this.getConnectURI() != null ? this.getConnectURI().hashCode() : 0);
        result = 31 * result + (this.getUser() != null ? this.getUser().hashCode() : 0);
        result = 31 * result + (this.passwordProvider != null ? this.passwordProvider.hashCode() : 0);
        result = 31 * result + (this.dbcpProperties != null ? this.dbcpProperties.hashCode() : 0);
        return result;
    }
}

