/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.timeline.partition.BuildingShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.PartitionChunk;

public class BuildingHashBasedNumberedShardSpec
implements BuildingShardSpec<HashBasedNumberedShardSpec> {
    public static final String TYPE = "building_hashed";
    private final int partitionId;
    private final int bucketId;
    private final int numBuckets;
    private final List<String> partitionDimensions;
    private final ObjectMapper jsonMapper;

    @JsonCreator
    public BuildingHashBasedNumberedShardSpec(@JsonProperty(value="partitionId") int partitionId, @JsonProperty(value="bucketId") int bucketId, @JsonProperty(value="numBuckets") int numBuckets, @JsonProperty(value="partitionDimensions") @Nullable List<String> partitionDimensions, @JacksonInject ObjectMapper jsonMapper) {
        this.partitionId = partitionId;
        this.bucketId = bucketId;
        this.numBuckets = numBuckets;
        this.partitionDimensions = partitionDimensions == null ? HashBasedNumberedShardSpec.DEFAULT_PARTITION_DIMENSIONS : partitionDimensions;
        this.jsonMapper = jsonMapper;
    }

    @Override
    @JsonProperty(value="partitionId")
    public int getPartitionNum() {
        return this.partitionId;
    }

    @Override
    @JsonProperty
    public int getBucketId() {
        return this.bucketId;
    }

    @JsonProperty
    public int getNumBuckets() {
        return this.numBuckets;
    }

    @JsonProperty
    public List<String> getPartitionDimensions() {
        return this.partitionDimensions;
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        return new NumberedPartitionChunk<T>(this.partitionId, 0, obj);
    }

    @Override
    public HashBasedNumberedShardSpec convert(int numCorePartitions) {
        return new HashBasedNumberedShardSpec(this.partitionId, numCorePartitions, this.bucketId, this.numBuckets, this.partitionDimensions, this.jsonMapper);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildingHashBasedNumberedShardSpec that = (BuildingHashBasedNumberedShardSpec)o;
        return this.partitionId == that.partitionId && this.bucketId == that.bucketId && this.numBuckets == that.numBuckets && Objects.equals(this.partitionDimensions, that.partitionDimensions);
    }

    public int hashCode() {
        return Objects.hash(this.partitionId, this.bucketId, this.numBuckets, this.partitionDimensions);
    }

    public String toString() {
        return "BuildingHashBasedNumberedShardSpec{partitionId=" + this.partitionId + ", bucketId=" + this.bucketId + ", numBuckets=" + this.numBuckets + ", partitionDimensions=" + this.partitionDimensions + '}';
    }
}

