/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.Rows;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;

public class HashBasedNumberedShardSpec
extends NumberedShardSpec {
    static final List<String> DEFAULT_PARTITION_DIMENSIONS = ImmutableList.of();
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_32();
    private final int bucketId;
    private final int numBuckets;
    private final ObjectMapper jsonMapper;
    @JsonIgnore
    private final List<String> partitionDimensions;

    @JsonCreator
    public HashBasedNumberedShardSpec(@JsonProperty(value="partitionNum") int partitionNum, @JsonProperty(value="partitions") int partitions, @JsonProperty(value="bucketId") @Nullable Integer bucketId, @JsonProperty(value="numBuckets") @Nullable Integer numBuckets, @JsonProperty(value="partitionDimensions") @Nullable List<String> partitionDimensions, @JacksonInject ObjectMapper jsonMapper) {
        super(partitionNum, partitions);
        this.bucketId = bucketId == null ? partitionNum : bucketId;
        this.numBuckets = numBuckets == null ? partitions : numBuckets;
        this.jsonMapper = jsonMapper;
        this.partitionDimensions = partitionDimensions == null ? DEFAULT_PARTITION_DIMENSIONS : partitionDimensions;
    }

    @JsonProperty
    public int getBucketId() {
        return this.bucketId;
    }

    @JsonProperty
    public int getNumBuckets() {
        return this.numBuckets;
    }

    @JsonProperty(value="partitionDimensions")
    public List<String> getPartitionDimensions() {
        return this.partitionDimensions;
    }

    @Override
    public boolean isInChunk(long timestamp, InputRow inputRow) {
        return ((long)this.hash(timestamp, inputRow) - (long)this.bucketId) % (long)this.numBuckets == 0L;
    }

    protected int hash(long timestamp, InputRow inputRow) {
        return HashBasedNumberedShardSpec.hash(this.jsonMapper, this.partitionDimensions, timestamp, inputRow);
    }

    public static int hash(ObjectMapper jsonMapper, List<String> partitionDimensions, long timestamp, InputRow inputRow) {
        List<Object> groupKey = HashBasedNumberedShardSpec.getGroupKey(partitionDimensions, timestamp, inputRow);
        try {
            return HashBasedNumberedShardSpec.hash(jsonMapper, groupKey);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static List<Object> getGroupKey(List<String> partitionDimensions, long timestamp, InputRow inputRow) {
        if (partitionDimensions.isEmpty()) {
            return Rows.toGroupKey(timestamp, inputRow);
        }
        return Lists.transform(partitionDimensions, inputRow::getDimension);
    }

    @VisibleForTesting
    public static int hash(ObjectMapper jsonMapper, List<Object> objects) throws JsonProcessingException {
        return HASH_FUNCTION.hashBytes(jsonMapper.writeValueAsBytes(objects)).asInt();
    }

    @Override
    public ShardSpecLookup getLookup(List<? extends ShardSpec> shardSpecs) {
        return HashBasedNumberedShardSpec.createHashLookup(this.jsonMapper, this.partitionDimensions, shardSpecs, this.numBuckets);
    }

    static ShardSpecLookup createHashLookup(ObjectMapper jsonMapper, List<String> partitionDimensions, List<? extends ShardSpec> shardSpecs, int numBuckets) {
        return (timestamp, row) -> {
            int index = Math.abs(HashBasedNumberedShardSpec.hash(jsonMapper, partitionDimensions, timestamp, row) % numBuckets);
            return (ShardSpec)shardSpecs.get(index);
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HashBasedNumberedShardSpec that = (HashBasedNumberedShardSpec)o;
        return this.bucketId == that.bucketId && this.numBuckets == that.numBuckets && Objects.equals(this.partitionDimensions, that.partitionDimensions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bucketId, this.numBuckets, this.partitionDimensions);
    }

    @Override
    public String toString() {
        return "HashBasedNumberedShardSpec{partitionNum=" + this.getPartitionNum() + ", partitions=" + this.getNumCorePartitions() + ", bucketId=" + this.bucketId + ", numBuckets=" + this.numBuckets + ", partitionDimensions=" + this.partitionDimensions + '}';
    }
}

