/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.google.common.collect.ForwardingList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class PartitionBoundaries
extends ForwardingList<String>
implements List<String> {
    private final List<String> delegate;

    private PartitionBoundaries() {
        this.delegate = new ArrayList<String>();
    }

    public PartitionBoundaries(String ... partitions) {
        if (partitions.length == 0) {
            this.delegate = Collections.emptyList();
            return;
        }
        List partitionBoundaries = Arrays.stream(partitions).distinct().collect(Collectors.toCollection(ArrayList::new));
        partitionBoundaries.set(0, null);
        if (partitionBoundaries.size() == 1) {
            partitionBoundaries.add(null);
        } else {
            partitionBoundaries.set(partitionBoundaries.size() - 1, null);
        }
        this.delegate = Collections.unmodifiableList(partitionBoundaries);
    }

    protected List<String> delegate() {
        return this.delegate;
    }

    public int getNumBuckets() {
        return this.delegate.size() - 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PartitionBoundaries strings = (PartitionBoundaries)o;
        return Objects.equals(this.delegate, strings.delegate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delegate);
    }
}

