/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.RangeSet;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.timeline.partition.BuildingHashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.BuildingNumberedShardSpec;
import org.apache.druid.timeline.partition.BuildingSingleDimensionShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.HashBucketShardSpec;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.NumberedOverwriteShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.RangeBucketShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="none", value=NoneShardSpec.class), @JsonSubTypes.Type(name="single", value=SingleDimensionShardSpec.class), @JsonSubTypes.Type(name="linear", value=LinearShardSpec.class), @JsonSubTypes.Type(name="numbered", value=NumberedShardSpec.class), @JsonSubTypes.Type(name="hashed", value=HashBasedNumberedShardSpec.class), @JsonSubTypes.Type(name="numbered_overwrite", value=NumberedOverwriteShardSpec.class), @JsonSubTypes.Type(name="building_numbered", value=BuildingNumberedShardSpec.class), @JsonSubTypes.Type(name="building_hashed", value=BuildingHashBasedNumberedShardSpec.class), @JsonSubTypes.Type(name="building_single_dim", value=BuildingSingleDimensionShardSpec.class), @JsonSubTypes.Type(name="bucket_hash", value=HashBucketShardSpec.class), @JsonSubTypes.Type(name="bucket_single_dim", value=RangeBucketShardSpec.class)})
public interface ShardSpec {
    @JsonIgnore
    public <T> PartitionChunk<T> createChunk(T var1);

    @JsonIgnore
    public boolean isInChunk(long var1, InputRow var3);

    public int getPartitionNum();

    public int getNumCorePartitions();

    default public int getStartRootPartitionId() {
        return this.getPartitionNum();
    }

    default public int getEndRootPartitionId() {
        return this.getPartitionNum() + 1;
    }

    default public short getMinorVersion() {
        return 0;
    }

    default public short getAtomicUpdateGroupSize() {
        return 1;
    }

    @JsonIgnore
    public ShardSpecLookup getLookup(List<? extends ShardSpec> var1);

    @JsonIgnore
    public List<String> getDomainDimensions();

    @JsonIgnore
    public boolean possibleInDomain(Map<String, RangeSet<String>> var1);

    default public boolean sharePartitionSpace(PartialShardSpec partialShardSpec) {
        return !partialShardSpec.useNonRootGenerationPartitionSpace();
    }
}

