/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;

public class SingleDimensionPartialShardSpec
implements PartialShardSpec {
    private final String partitionDimension;
    private final int bucketId;
    @Nullable
    private final String start;
    @Nullable
    private final String end;
    private final int numBuckets;

    @JsonCreator
    public SingleDimensionPartialShardSpec(@JsonProperty(value="partitionDimension") String partitionDimension, @JsonProperty(value="bucketId") int bucketId, @JsonProperty(value="start") @Nullable String start, @JsonProperty(value="end") @Nullable String end, @JsonProperty(value="numBuckets") int numBuckets) {
        this.partitionDimension = partitionDimension;
        this.bucketId = bucketId;
        this.start = start;
        this.end = end;
        this.numBuckets = numBuckets;
    }

    @JsonProperty
    public String getPartitionDimension() {
        return this.partitionDimension;
    }

    @JsonProperty
    public int getBucketId() {
        return this.bucketId;
    }

    @JsonProperty
    @Nullable
    public String getStart() {
        return this.start;
    }

    @JsonProperty
    @Nullable
    public String getEnd() {
        return this.end;
    }

    @JsonProperty
    public int getNumBuckets() {
        return this.numBuckets;
    }

    @Override
    public ShardSpec complete(ObjectMapper objectMapper, int partitionId, int numCorePartitions) {
        return new SingleDimensionShardSpec(this.partitionDimension, this.start, this.end, partitionId, numCorePartitions);
    }

    @Override
    public Class<? extends ShardSpec> getShardSpecClass() {
        return SingleDimensionShardSpec.class;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleDimensionPartialShardSpec that = (SingleDimensionPartialShardSpec)o;
        return this.bucketId == that.bucketId && this.numBuckets == that.numBuckets && Objects.equals(this.partitionDimension, that.partitionDimension) && Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end);
    }

    public int hashCode() {
        return Objects.hash(this.partitionDimension, this.bucketId, this.start, this.end, this.numBuckets);
    }
}

