/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.facebook.presto.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import com.facebook.presto.hadoop.$internal.com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.OutOfV1GenerationStampsException;
import org.apache.hadoop.hdfs.server.blockmanagement.SequentialBlockIdGenerator;
import org.apache.hadoop.hdfs.server.common.GenerationStamp;

public class BlockIdManager {
    private final GenerationStamp generationStampV1 = new GenerationStamp();
    private final GenerationStamp generationStampV2 = new GenerationStamp();
    private long generationStampV1Limit = 0L;
    private final SequentialBlockIdGenerator blockIdGenerator;

    public BlockIdManager(BlockManager blockManager) {
        this.blockIdGenerator = new SequentialBlockIdGenerator(blockManager);
    }

    public long upgradeGenerationStampToV2() {
        Preconditions.checkState(this.generationStampV2.getCurrentValue() == 1000L);
        this.generationStampV2.skipTo(this.generationStampV1.getCurrentValue() + 0x10000000000L);
        this.generationStampV1Limit = this.generationStampV2.getCurrentValue();
        return this.generationStampV2.getCurrentValue();
    }

    public void setGenerationStampV1Limit(long stamp) {
        Preconditions.checkState(this.generationStampV1Limit == 0L);
        this.generationStampV1Limit = stamp;
    }

    public long getGenerationStampAtblockIdSwitch() {
        return this.generationStampV1Limit;
    }

    @VisibleForTesting
    SequentialBlockIdGenerator getBlockIdGenerator() {
        return this.blockIdGenerator;
    }

    public void setLastAllocatedBlockId(long blockId) {
        this.blockIdGenerator.skipTo(blockId);
    }

    public long getLastAllocatedBlockId() {
        return this.blockIdGenerator.getCurrentValue();
    }

    public void setGenerationStampV1(long stamp) {
        this.generationStampV1.setCurrentValue(stamp);
    }

    public long getGenerationStampV1() {
        return this.generationStampV1.getCurrentValue();
    }

    public void setGenerationStampV2(long stamp) {
        this.generationStampV2.setCurrentValue(stamp);
    }

    public long getGenerationStampV2() {
        return this.generationStampV2.getCurrentValue();
    }

    public long nextGenerationStamp(boolean legacyBlock) throws IOException {
        return legacyBlock ? this.getNextGenerationStampV1() : this.getNextGenerationStampV2();
    }

    @VisibleForTesting
    long getNextGenerationStampV1() throws IOException {
        long genStampV1 = this.generationStampV1.nextValue();
        if (genStampV1 >= this.generationStampV1Limit) {
            throw new OutOfV1GenerationStampsException();
        }
        return genStampV1;
    }

    @VisibleForTesting
    long getNextGenerationStampV2() {
        return this.generationStampV2.nextValue();
    }

    public long getGenerationStampV1Limit() {
        return this.generationStampV1Limit;
    }

    public boolean isLegacyBlock(Block block) {
        return block.getGenerationStamp() < this.getGenerationStampV1Limit();
    }

    public long nextBlockId() {
        return this.blockIdGenerator.nextValue();
    }

    public boolean isGenStampInFuture(Block block) {
        if (this.isLegacyBlock(block)) {
            return block.getGenerationStamp() > this.getGenerationStampV1();
        }
        return block.getGenerationStamp() > this.getGenerationStampV2();
    }

    public void clear() {
        this.generationStampV1.setCurrentValue(1000L);
        this.generationStampV2.setCurrentValue(1000L);
        this.getBlockIdGenerator().setCurrentValue(0x40000000L);
        this.generationStampV1Limit = 0L;
    }
}

