/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.facebook.presto.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import com.facebook.presto.hadoop.$internal.com.google.common.base.Joiner;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeStatus;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActorAction;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActorActionException;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.IncrementalBlockReportManager;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.DisallowedDatanodeException;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.VersionUtil;

@InterfaceAudience.Private
class BPServiceActor
implements Runnable {
    static final Log LOG = DataNode.LOG;
    final InetSocketAddress nnAddr;
    HAServiceProtocol.HAServiceState state;
    final BPOfferService bpos;
    volatile long lastCacheReport = 0L;
    private final Scheduler scheduler;
    Thread bpThread;
    DatanodeProtocolClientSideTranslatorPB bpNamenode;
    private volatile RunningState runningState = RunningState.CONNECTING;
    private volatile boolean shouldServiceRun = true;
    private final DataNode dn;
    private final DNConf dnConf;
    private long prevBlockReportId = 0L;
    private final IncrementalBlockReportManager ibrManager;
    private DatanodeRegistration bpRegistration;
    final LinkedList<BPServiceActorAction> bpThreadQueue = new LinkedList();

    BPServiceActor(InetSocketAddress nnAddr, BPOfferService bpos) {
        this.bpos = bpos;
        this.dn = bpos.getDataNode();
        this.nnAddr = nnAddr;
        this.dnConf = this.dn.getDnConf();
        this.ibrManager = new IncrementalBlockReportManager(this.dnConf.ibrInterval);
        this.scheduler = new Scheduler(this.dnConf.heartBeatInterval, this.dnConf.blockReportInterval);
    }

    public DatanodeRegistration getBpRegistration() {
        return this.bpRegistration;
    }

    IncrementalBlockReportManager getIbrManager() {
        return this.ibrManager;
    }

    boolean isAlive() {
        if (!this.shouldServiceRun || !this.bpThread.isAlive()) {
            return false;
        }
        return this.runningState == RunningState.RUNNING || this.runningState == RunningState.CONNECTING;
    }

    public String toString() {
        return this.bpos.toString() + " service to " + this.nnAddr;
    }

    InetSocketAddress getNNSocketAddress() {
        return this.nnAddr;
    }

    @VisibleForTesting
    void setNameNode(DatanodeProtocolClientSideTranslatorPB dnProtocol) {
        this.bpNamenode = dnProtocol;
    }

    @VisibleForTesting
    DatanodeProtocolClientSideTranslatorPB getNameNodeProxy() {
        return this.bpNamenode;
    }

    @VisibleForTesting
    NamespaceInfo retrieveNamespaceInfo() throws IOException {
        NamespaceInfo nsInfo = null;
        while (this.shouldRun()) {
            try {
                nsInfo = this.bpNamenode.versionRequest();
                LOG.debug(this + " received versionRequest response: " + nsInfo);
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.warn("Problem connecting to server: " + this.nnAddr);
            }
            catch (IOException e) {
                LOG.warn("Problem connecting to server: " + this.nnAddr);
            }
            this.sleepAndLogInterrupts(5000, "requesting version info from NN");
        }
        if (nsInfo == null) {
            throw new IOException("DN shut down before block pool connected");
        }
        this.checkNNVersion(nsInfo);
        return nsInfo;
    }

    private void checkNNVersion(NamespaceInfo nsInfo) throws IncorrectVersionException {
        String minimumNameNodeVersion;
        String nnVersion = nsInfo.getSoftwareVersion();
        if (VersionUtil.compareVersions(nnVersion, minimumNameNodeVersion = this.dnConf.getMinimumNameNodeVersion()) < 0) {
            IncorrectVersionException ive = new IncorrectVersionException(minimumNameNodeVersion, nnVersion, "NameNode", "DataNode");
            LOG.warn(ive.getMessage());
            throw ive;
        }
        String dnVersion = VersionInfo.getVersion();
        if (!nnVersion.equals(dnVersion)) {
            LOG.info("Reported NameNode version '" + nnVersion + "' does not match " + "DataNode version '" + dnVersion + "' but is within acceptable " + "limits. Note: This is normal during a rolling upgrade.");
        }
    }

    private void connectToNNAndHandshake() throws IOException {
        this.bpNamenode = this.dn.connectToNN(this.nnAddr);
        NamespaceInfo nsInfo = this.retrieveNamespaceInfo();
        this.bpos.verifyAndSetNamespaceInfo(nsInfo);
        this.register(nsInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void triggerBlockReportForTests() {
        IncrementalBlockReportManager incrementalBlockReportManager = this.ibrManager;
        synchronized (incrementalBlockReportManager) {
            this.scheduler.scheduleHeartbeat();
            long nextBlockReportTime = this.scheduler.scheduleBlockReport(0L);
            this.ibrManager.notifyAll();
            while (nextBlockReportTime - this.scheduler.nextBlockReportTime >= 0L) {
                try {
                    this.ibrManager.wait(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void triggerHeartbeatForTests() {
        IncrementalBlockReportManager incrementalBlockReportManager = this.ibrManager;
        synchronized (incrementalBlockReportManager) {
            long nextHeartbeatTime = this.scheduler.scheduleHeartbeat();
            this.ibrManager.notifyAll();
            while (nextHeartbeatTime - this.scheduler.nextHeartbeatTime >= 0L) {
                try {
                    this.ibrManager.wait(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    private long generateUniqueBlockReportId() {
        long id = System.nanoTime();
        if (id <= this.prevBlockReportId) {
            id = this.prevBlockReportId + 1L;
        }
        this.prevBlockReportId = id;
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DatanodeCommand> blockReport() throws IOException {
        if (!this.scheduler.isBlockReportDue()) {
            return null;
        }
        ArrayList<DatanodeCommand> cmds = new ArrayList<DatanodeCommand>();
        this.ibrManager.sendIBRs(this.bpNamenode, this.bpRegistration, this.bpos.getBlockPoolId(), this.dn.getMetrics());
        long brCreateStartTime = Time.monotonicNow();
        Map<DatanodeStorage, BlockListAsLongs> perVolumeBlockLists = this.dn.getFSDataset().getBlockReports(this.bpos.getBlockPoolId());
        int i = 0;
        int totalBlockCount = 0;
        StorageBlockReport[] reports = new StorageBlockReport[perVolumeBlockLists.size()];
        for (Map.Entry<DatanodeStorage, BlockListAsLongs> kvPair : perVolumeBlockLists.entrySet()) {
            BlockListAsLongs blockList = kvPair.getValue();
            reports[i++] = new StorageBlockReport(kvPair.getKey(), blockList);
            totalBlockCount += blockList.getNumberOfBlocks();
        }
        int numReportsSent = 0;
        int numRPCs = 0;
        boolean success = false;
        long brSendStartTime = Time.monotonicNow();
        long reportId = this.generateUniqueBlockReportId();
        try {
            if ((long)totalBlockCount < this.dnConf.blockReportSplitThreshold) {
                DatanodeCommand cmd = this.bpNamenode.blockReport(this.bpRegistration, this.bpos.getBlockPoolId(), reports, new BlockReportContext(1, 0, reportId));
                numRPCs = 1;
                numReportsSent = reports.length;
                if (cmd != null) {
                    cmds.add(cmd);
                }
            } else {
                for (int r = 0; r < reports.length; ++r) {
                    StorageBlockReport[] singleReport = new StorageBlockReport[]{reports[r]};
                    DatanodeCommand cmd = this.bpNamenode.blockReport(this.bpRegistration, this.bpos.getBlockPoolId(), singleReport, new BlockReportContext(reports.length, r, reportId));
                    ++numReportsSent;
                    ++numRPCs;
                    if (cmd == null) continue;
                    cmds.add(cmd);
                }
            }
            success = true;
        }
        catch (Throwable throwable) {
            long brSendCost = Time.monotonicNow() - brSendStartTime;
            long brCreateCost = brSendStartTime - brCreateStartTime;
            this.dn.getMetrics().addBlockReport(brSendCost);
            int nCmds = cmds.size();
            LOG.info((success ? "S" : "Uns") + "uccessfully sent block report 0x" + Long.toHexString(reportId) + ",  containing " + reports.length + " storage report(s), of which we sent " + numReportsSent + "." + " The reports had " + totalBlockCount + " total blocks and used " + numRPCs + " RPC(s). This took " + brCreateCost + " msec to generate and " + brSendCost + " msecs for RPC and NN processing." + " Got back " + (nCmds == 0 ? "no commands" : (nCmds == 1 ? "one command: " + cmds.get(0) : nCmds + " commands: " + Joiner.on("; ").join(cmds))) + ".");
            throw throwable;
        }
        long brSendCost = Time.monotonicNow() - brSendStartTime;
        long brCreateCost = brSendStartTime - brCreateStartTime;
        this.dn.getMetrics().addBlockReport(brSendCost);
        int nCmds = cmds.size();
        LOG.info((success ? "S" : "Uns") + "uccessfully sent block report 0x" + Long.toHexString(reportId) + ",  containing " + reports.length + " storage report(s), of which we sent " + numReportsSent + "." + " The reports had " + totalBlockCount + " total blocks and used " + numRPCs + " RPC(s). This took " + brCreateCost + " msec to generate and " + brSendCost + " msecs for RPC and NN processing." + " Got back " + (nCmds == 0 ? "no commands" : (nCmds == 1 ? "one command: " + cmds.get(0) : nCmds + " commands: " + Joiner.on("; ").join(cmds))) + ".");
        this.scheduler.scheduleNextBlockReport();
        return cmds.size() == 0 ? null : cmds;
    }

    DatanodeCommand cacheReport() throws IOException {
        if (this.dn.getFSDataset().getCacheCapacity() == 0L) {
            return null;
        }
        DatanodeCommand cmd = null;
        long startTime = Time.monotonicNow();
        if (startTime - this.lastCacheReport > this.dnConf.cacheReportInterval) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending cacheReport from service actor: " + this);
            }
            this.lastCacheReport = startTime;
            String bpid = this.bpos.getBlockPoolId();
            List<Long> blockIds = this.dn.getFSDataset().getCacheReport(bpid);
            long createTime = Time.monotonicNow();
            cmd = this.bpNamenode.cacheReport(this.bpRegistration, bpid, blockIds);
            long sendTime = Time.monotonicNow();
            long createCost = createTime - startTime;
            long sendCost = sendTime - createTime;
            this.dn.getMetrics().addCacheReport(sendCost);
            LOG.debug("CacheReport of " + blockIds.size() + " block(s) took " + createCost + " msec to generate and " + sendCost + " msecs for RPC and NN processing");
        }
        return cmd;
    }

    HeartbeatResponse sendHeartBeat() throws IOException {
        VolumeFailureSummary volumeFailureSummary;
        this.scheduler.scheduleNextHeartbeat();
        StorageReport[] reports = this.dn.getFSDataset().getStorageReports(this.bpos.getBlockPoolId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending heartbeat with " + reports.length + " storage reports from service actor: " + this);
        }
        int numFailedVolumes = (volumeFailureSummary = this.dn.getFSDataset().getVolumeFailureSummary()) != null ? volumeFailureSummary.getFailedStorageLocations().length : 0;
        return this.bpNamenode.sendHeartbeat(this.bpRegistration, reports, this.dn.getFSDataset().getCacheCapacity(), this.dn.getFSDataset().getCacheUsed(), this.dn.getXmitsInProgress(), this.dn.getXceiverCount(), numFailedVolumes, volumeFailureSummary);
    }

    void start() {
        if (this.bpThread != null && this.bpThread.isAlive()) {
            return;
        }
        this.bpThread = new Thread((Runnable)this, this.formatThreadName());
        this.bpThread.setDaemon(true);
        this.bpThread.start();
    }

    private String formatThreadName() {
        List<StorageLocation> dataDirs = DataNode.getStorageLocations(this.dn.getConf());
        return "DataNode: [" + dataDirs.toString() + "] " + " heartbeating to " + this.nnAddr;
    }

    void stop() {
        this.shouldServiceRun = false;
        if (this.bpThread != null) {
            this.bpThread.interrupt();
        }
    }

    void join() {
        try {
            if (this.bpThread != null) {
                this.bpThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void cleanUp() {
        this.shouldServiceRun = false;
        IOUtils.cleanup(LOG, this.bpNamenode);
        this.bpos.shutdownActor(this);
    }

    private void handleRollingUpgradeStatus(HeartbeatResponse resp) throws IOException {
        RollingUpgradeStatus rollingUpgradeStatus = resp.getRollingUpdateStatus();
        if (rollingUpgradeStatus != null && rollingUpgradeStatus.getBlockPoolId().compareTo(this.bpos.getBlockPoolId()) != 0) {
            LOG.error("Invalid BlockPoolId " + rollingUpgradeStatus.getBlockPoolId() + " in HeartbeatResponse. Expected " + this.bpos.getBlockPoolId());
        } else {
            this.bpos.signalRollingUpgrade(rollingUpgradeStatus);
        }
    }

    private void offerService() throws Exception {
        LOG.info("For namenode " + this.nnAddr + " using" + " BLOCKREPORT_INTERVAL of " + this.dnConf.blockReportInterval + "msec" + " CACHEREPORT_INTERVAL of " + this.dnConf.cacheReportInterval + "msec" + " Initial delay: " + this.dnConf.initialBlockReportDelay + "msec" + "; heartBeatInterval=" + this.dnConf.heartBeatInterval);
        while (this.shouldRun()) {
            try {
                List<DatanodeCommand> cmds;
                long startTime = this.scheduler.monotonicNow();
                boolean sendHeartbeat = this.scheduler.isHeartbeatDue(startTime);
                if (sendHeartbeat && !this.dn.areHeartbeatsDisabledForTests()) {
                    HeartbeatResponse resp = this.sendHeartBeat();
                    assert (resp != null);
                    this.dn.getMetrics().addHeartbeat(this.scheduler.monotonicNow() - startTime);
                    this.bpos.updateActorStatesFromHeartbeat(this, resp.getNameNodeHaState());
                    this.state = resp.getNameNodeHaState().getState();
                    if (this.state == HAServiceProtocol.HAServiceState.ACTIVE) {
                        this.handleRollingUpgradeStatus(resp);
                    }
                    long startProcessCommands = Time.monotonicNow();
                    if (!this.processCommand(resp.getCommands())) continue;
                    long endProcessCommands = Time.monotonicNow();
                    if (endProcessCommands - startProcessCommands > 2000L) {
                        LOG.info("Took " + (endProcessCommands - startProcessCommands) + "ms to process " + resp.getCommands().length + " commands from NN");
                    }
                }
                if (this.ibrManager.sendImmediately() || sendHeartbeat) {
                    this.ibrManager.sendIBRs(this.bpNamenode, this.bpRegistration, this.bpos.getBlockPoolId(), this.dn.getMetrics());
                }
                this.processCommand((cmds = this.blockReport()) == null ? null : cmds.toArray(new DatanodeCommand[cmds.size()]));
                DatanodeCommand cmd = this.cacheReport();
                this.processCommand(new DatanodeCommand[]{cmd});
                this.ibrManager.waitTillNextIBR(this.scheduler.getHeartbeatWaitTime());
            }
            catch (RemoteException re) {
                String reClass = re.getClassName();
                if (UnregisteredNodeException.class.getName().equals(reClass) || DisallowedDatanodeException.class.getName().equals(reClass) || IncorrectVersionException.class.getName().equals(reClass)) {
                    LOG.warn(this + " is shutting down", re);
                    this.shouldServiceRun = false;
                    return;
                }
                LOG.warn("RemoteException in offerService", re);
                try {
                    long sleepTime = Math.min(1000L, this.dnConf.heartBeatInterval);
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (IOException e) {
                LOG.warn("IOException in offerService", e);
            }
            this.processQueueMessages();
        }
    }

    void register(NamespaceInfo nsInfo) throws IOException {
        DatanodeRegistration newBpRegistration = this.bpos.createRegistration();
        LOG.info(this + " beginning handshake with NN");
        while (this.shouldRun()) {
            try {
                newBpRegistration = this.bpNamenode.registerDatanode(newBpRegistration);
                newBpRegistration.setNamespaceInfo(nsInfo);
                this.bpRegistration = newBpRegistration;
                break;
            }
            catch (EOFException e) {
                LOG.info("Problem connecting to server: " + this.nnAddr + " :" + e.getLocalizedMessage());
                this.sleepAndLogInterrupts(1000, "connecting to server");
            }
            catch (SocketTimeoutException e) {
                LOG.info("Problem connecting to server: " + this.nnAddr);
                this.sleepAndLogInterrupts(1000, "connecting to server");
            }
        }
        LOG.info("Block pool " + this + " successfully registered with NN");
        this.bpos.registrationSucceeded(this, this.bpRegistration);
        this.scheduler.scheduleBlockReport(this.dnConf.initialBlockReportDelay);
    }

    private void sleepAndLogInterrupts(int millis, String stateString) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ie) {
            LOG.info("BPOfferService " + this + " interrupted while " + stateString);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        LOG.info(this + " starting to offer service");
        try {
            while (true) {
                try {
                    this.connectToNNAndHandshake();
                }
                catch (IOException ioe) {
                    this.runningState = RunningState.INIT_FAILED;
                    if (!this.shouldRetryInit()) {
                        this.runningState = RunningState.FAILED;
                        LOG.fatal("Initialization failed for " + this + ". Exiting. ", ioe);
                        LOG.warn("Ending block pool service for: " + this);
                        this.cleanUp();
                        return;
                    }
                    LOG.error("Initialization failed for " + this + " " + ioe.getLocalizedMessage());
                    this.sleepAndLogInterrupts(5000, "initializing");
                    continue;
                }
                break;
            }
            this.runningState = RunningState.RUNNING;
        }
        catch (Throwable ex) {
            LOG.warn("Unexpected exception in block pool " + this, ex);
            this.runningState = RunningState.FAILED;
            return;
        }
        finally {
            LOG.warn("Ending block pool service for: " + this);
            this.cleanUp();
        }
        while (true) {
            if (!this.shouldRun()) {
                this.runningState = RunningState.EXITED;
                return;
            }
            try {
                this.offerService();
            }
            catch (Exception ex) {
                LOG.error("Exception in BPOfferService for " + this, ex);
                this.sleepAndLogInterrupts(5000, "offering service");
                continue;
            }
            break;
        }
    }

    private boolean shouldRetryInit() {
        return this.shouldRun() && this.bpos.shouldRetryInit();
    }

    private boolean shouldRun() {
        return this.shouldServiceRun && this.dn.shouldRun();
    }

    boolean processCommand(DatanodeCommand[] cmds) {
        if (cmds != null) {
            for (DatanodeCommand cmd : cmds) {
                try {
                    if (!this.bpos.processCommandFromActor(cmd, this)) {
                        return false;
                    }
                }
                catch (IOException ioe) {
                    LOG.warn("Error processing datanode Command", ioe);
                }
            }
        }
        return true;
    }

    void reportRemoteBadBlock(DatanodeInfo dnInfo, ExtendedBlock block) throws IOException {
        LocatedBlock lb = new LocatedBlock(block, new DatanodeInfo[]{dnInfo});
        this.bpNamenode.reportBadBlocks(new LocatedBlock[]{lb});
    }

    void reRegister() throws IOException {
        if (this.shouldRun()) {
            NamespaceInfo nsInfo = this.retrieveNamespaceInfo();
            this.register(nsInfo);
            this.scheduler.scheduleHeartbeat();
            if (this.state == HAServiceProtocol.HAServiceState.STANDBY) {
                this.ibrManager.clearIBRs();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void triggerBlockReport(BlockReportOptions options) {
        if (options.isIncremental()) {
            LOG.info(this.bpos.toString() + ": scheduling an incremental block report.");
            this.ibrManager.triggerIBR(true);
        } else {
            LOG.info(this.bpos.toString() + ": scheduling a full block report.");
            IncrementalBlockReportManager incrementalBlockReportManager = this.ibrManager;
            synchronized (incrementalBlockReportManager) {
                this.scheduler.scheduleBlockReport(0L);
                this.ibrManager.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bpThreadEnqueue(BPServiceActorAction action) {
        LinkedList<BPServiceActorAction> linkedList = this.bpThreadQueue;
        synchronized (linkedList) {
            if (!this.bpThreadQueue.contains(action)) {
                this.bpThreadQueue.add(action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueueMessages() {
        LinkedList<BPServiceActorAction> duplicateQueue;
        LinkedList<BPServiceActorAction> linkedList = this.bpThreadQueue;
        synchronized (linkedList) {
            duplicateQueue = new LinkedList<BPServiceActorAction>(this.bpThreadQueue);
            this.bpThreadQueue.clear();
        }
        while (!duplicateQueue.isEmpty()) {
            BPServiceActorAction actionItem = duplicateQueue.remove();
            try {
                actionItem.reportTo(this.bpNamenode, this.bpRegistration);
            }
            catch (BPServiceActorActionException baae) {
                LOG.warn(baae.getMessage() + this.nnAddr, baae);
                this.bpThreadEnqueue(actionItem);
            }
        }
    }

    Scheduler getScheduler() {
        return this.scheduler;
    }

    static class Scheduler {
        @VisibleForTesting
        volatile long nextBlockReportTime = this.monotonicNow();
        @VisibleForTesting
        volatile long nextHeartbeatTime = this.monotonicNow();
        @VisibleForTesting
        boolean resetBlockReportTime = true;
        private final long heartbeatIntervalMs;
        private final long blockReportIntervalMs;

        Scheduler(long heartbeatIntervalMs, long blockReportIntervalMs) {
            this.heartbeatIntervalMs = heartbeatIntervalMs;
            this.blockReportIntervalMs = blockReportIntervalMs;
        }

        long scheduleHeartbeat() {
            this.nextHeartbeatTime = this.monotonicNow();
            return this.nextHeartbeatTime;
        }

        long scheduleNextHeartbeat() {
            this.nextHeartbeatTime = this.monotonicNow() + this.heartbeatIntervalMs;
            return this.nextHeartbeatTime;
        }

        boolean isHeartbeatDue(long startTime) {
            return this.nextHeartbeatTime - startTime <= 0L;
        }

        boolean isBlockReportDue() {
            return this.nextBlockReportTime - this.monotonicNow() <= 0L;
        }

        long scheduleBlockReport(long delay) {
            this.nextBlockReportTime = delay > 0L ? this.monotonicNow() + (long)DFSUtil.getRandom().nextInt((int)delay) : this.monotonicNow();
            this.resetBlockReportTime = true;
            return this.nextBlockReportTime;
        }

        void scheduleNextBlockReport() {
            if (this.resetBlockReportTime) {
                this.nextBlockReportTime = this.monotonicNow() + (long)DFSUtil.getRandom().nextInt((int)this.blockReportIntervalMs);
                this.resetBlockReportTime = false;
            } else {
                this.nextBlockReportTime += (this.monotonicNow() - this.nextBlockReportTime + this.blockReportIntervalMs) / this.blockReportIntervalMs * this.blockReportIntervalMs;
            }
        }

        long getHeartbeatWaitTime() {
            return this.nextHeartbeatTime - this.monotonicNow();
        }

        @VisibleForTesting
        public long monotonicNow() {
            return Time.monotonicNow();
        }
    }

    static enum RunningState {
        CONNECTING,
        INIT_FAILED,
        RUNNING,
        EXITED,
        FAILED;

    }
}

