/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.auth;

import java.util.Set;
import java.util.stream.Collectors;

public class BasicAuthPrincipal {
    private final String _name;
    private final String _token;
    private final Set<String> _tables;
    private final Set<String> _permissions;

    public BasicAuthPrincipal(String name, String token, Set<String> tables, Set<String> permissions) {
        this._name = name;
        this._token = token;
        this._tables = tables;
        this._permissions = permissions.stream().map(s -> s.toLowerCase()).collect(Collectors.toSet());
    }

    public String getName() {
        return this._name;
    }

    public String getToken() {
        return this._token;
    }

    public boolean hasTable(String tableName) {
        return this._tables.isEmpty() || this._tables.contains(tableName);
    }

    public boolean hasPermission(String permission) {
        return this._permissions.isEmpty() || this._permissions.contains(permission.toLowerCase());
    }

    public String toString() {
        return "BasicAuthPrincipal{_name='" + this._name + '\'' + ", _token='" + this._token + '\'' + ", _tables=" + this._tables + ", _permissions=" + this._permissions + '}';
    }
}

