/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datatable;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.common.datatable.DataTableImplV2;
import org.apache.pinot.core.common.datatable.DataTableImplV3;
import org.apache.pinot.core.common.datatable.DataTableUtils;
import org.apache.pinot.spi.utils.ByteArray;

public class DataTableBuilder {
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    private static int _version = 3;
    private final DataSchema _dataSchema;
    private final int[] _columnOffsets;
    private final int _rowSizeInBytes;
    private final Map<String, Map<String, Integer>> _dictionaryMap = new HashMap<String, Map<String, Integer>>();
    private final Map<String, Map<Integer, String>> _reverseDictionaryMap = new HashMap<String, Map<Integer, String>>();
    private final ByteArrayOutputStream _fixedSizeDataByteArrayOutputStream = new ByteArrayOutputStream();
    private final ByteArrayOutputStream _variableSizeDataByteArrayOutputStream = new ByteArrayOutputStream();
    private final DataOutputStream _variableSizeDataOutputStream = new DataOutputStream(this._variableSizeDataByteArrayOutputStream);
    private int _numRows;
    private ByteBuffer _currentRowDataByteBuffer;

    public DataTableBuilder(DataSchema dataSchema) {
        this._dataSchema = dataSchema;
        this._columnOffsets = new int[dataSchema.size()];
        this._rowSizeInBytes = DataTableUtils.computeColumnOffsets(dataSchema, this._columnOffsets);
    }

    public static DataTable getEmptyDataTable() {
        return _version == 2 ? new DataTableImplV2() : new DataTableImplV3();
    }

    public static void setCurrentDataTableVersion(int version) {
        if (version != 2 && version != 3) {
            throw new IllegalArgumentException("Unsupported version: " + version);
        }
        _version = version;
    }

    public void startRow() {
        ++this._numRows;
        this._currentRowDataByteBuffer = ByteBuffer.allocate(this._rowSizeInBytes);
    }

    public void setColumn(int colId, boolean value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        if (value) {
            this._currentRowDataByteBuffer.put((byte)1);
        } else {
            this._currentRowDataByteBuffer.put((byte)0);
        }
    }

    public void setColumn(int colId, byte value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.put(value);
    }

    public void setColumn(int colId, char value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putChar(value);
    }

    public void setColumn(int colId, short value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putShort(value);
    }

    public void setColumn(int colId, int value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(value);
    }

    public void setColumn(int colId, long value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putLong(value);
    }

    public void setColumn(int colId, float value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putFloat(value);
    }

    public void setColumn(int colId, double value) {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putDouble(value);
    }

    public void setColumn(int colId, String value) {
        String columnName = this._dataSchema.getColumnName(colId);
        Map<String, Integer> dictionary = this._dictionaryMap.get(columnName);
        if (dictionary == null) {
            dictionary = new HashMap<String, Integer>();
            this._dictionaryMap.put(columnName, dictionary);
            this._reverseDictionaryMap.put(columnName, new HashMap());
        }
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        Integer dictId = dictionary.get(value);
        if (dictId == null) {
            dictId = dictionary.size();
            dictionary.put(value, dictId);
            this._reverseDictionaryMap.get(columnName).put(dictId, value);
        }
        this._currentRowDataByteBuffer.putInt(dictId);
    }

    public void setColumn(int colId, ByteArray value) throws IOException {
        this.setColumn(colId, value.toHexString());
    }

    public void setColumn(int colId, Object value) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        int objectTypeValue = ObjectSerDeUtils.ObjectType.getObjectType(value).getValue();
        byte[] bytes = ObjectSerDeUtils.serialize(value, objectTypeValue);
        this._currentRowDataByteBuffer.putInt(bytes.length);
        this._variableSizeDataOutputStream.writeInt(objectTypeValue);
        this._variableSizeDataByteArrayOutputStream.write(bytes);
    }

    public void setColumn(int colId, int[] values) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        for (int value : values) {
            this._variableSizeDataOutputStream.writeInt(value);
        }
    }

    public void setColumn(int colId, long[] values) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        for (long value : values) {
            this._variableSizeDataOutputStream.writeLong(value);
        }
    }

    public void setColumn(int colId, float[] values) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        for (float value : values) {
            this._variableSizeDataOutputStream.writeFloat(value);
        }
    }

    public void setColumn(int colId, double[] values) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        for (double value : values) {
            this._variableSizeDataOutputStream.writeDouble(value);
        }
    }

    public void setColumn(int colId, String[] values) throws IOException {
        this._currentRowDataByteBuffer.position(this._columnOffsets[colId]);
        this._currentRowDataByteBuffer.putInt(this._variableSizeDataByteArrayOutputStream.size());
        this._currentRowDataByteBuffer.putInt(values.length);
        String columnName = this._dataSchema.getColumnName(colId);
        Map<String, Integer> dictionary = this._dictionaryMap.get(columnName);
        if (dictionary == null) {
            dictionary = new HashMap<String, Integer>();
            this._dictionaryMap.put(columnName, dictionary);
            this._reverseDictionaryMap.put(columnName, new HashMap());
        }
        for (String value : values) {
            Integer dictId = dictionary.get(value);
            if (dictId == null) {
                dictId = dictionary.size();
                dictionary.put(value, dictId);
                this._reverseDictionaryMap.get(columnName).put(dictId, value);
            }
            this._variableSizeDataOutputStream.writeInt(dictId);
        }
    }

    public void finishRow() throws IOException {
        this._fixedSizeDataByteArrayOutputStream.write(this._currentRowDataByteBuffer.array());
    }

    public DataTable build() {
        return _version == 2 ? new DataTableImplV2(this._numRows, this._dataSchema, this._reverseDictionaryMap, this._fixedSizeDataByteArrayOutputStream.toByteArray(), this._variableSizeDataByteArrayOutputStream.toByteArray()) : new DataTableImplV3(this._numRows, this._dataSchema, this._reverseDictionaryMap, this._fixedSizeDataByteArrayOutputStream.toByteArray(), this._variableSizeDataByteArrayOutputStream.toByteArray());
    }
}

