/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datatable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.datatable.BaseDataTable;
import org.apache.pinot.core.common.datatable.DataTableUtils;

public class DataTableImplV2
extends BaseDataTable {
    private static final int HEADER_SIZE = 52;

    public DataTableImplV2(int numRows, DataSchema dataSchema, Map<String, Map<Integer, String>> dictionaryMap, byte[] fixedSizeDataBytes, byte[] variableSizeDataBytes) {
        super(numRows, dataSchema, dictionaryMap, fixedSizeDataBytes, variableSizeDataBytes);
    }

    public DataTableImplV2() {
    }

    public DataTableImplV2(ByteBuffer byteBuffer) throws IOException {
        this._numRows = byteBuffer.getInt();
        this._numColumns = byteBuffer.getInt();
        int dictionaryMapStart = byteBuffer.getInt();
        int dictionaryMapLength = byteBuffer.getInt();
        int metadataStart = byteBuffer.getInt();
        int metadataLength = byteBuffer.getInt();
        int dataSchemaStart = byteBuffer.getInt();
        int dataSchemaLength = byteBuffer.getInt();
        int fixedSizeDataStart = byteBuffer.getInt();
        int fixedSizeDataLength = byteBuffer.getInt();
        int variableSizeDataStart = byteBuffer.getInt();
        int variableSizeDataLength = byteBuffer.getInt();
        if (dictionaryMapLength != 0) {
            byte[] dictionaryMapBytes = new byte[dictionaryMapLength];
            byteBuffer.position(dictionaryMapStart);
            byteBuffer.get(dictionaryMapBytes);
            this._dictionaryMap = this.deserializeDictionaryMap(dictionaryMapBytes);
        } else {
            this._dictionaryMap = null;
        }
        byte[] metadataBytes = new byte[metadataLength];
        byteBuffer.position(metadataStart);
        byteBuffer.get(metadataBytes);
        this._metadata = this.deserializeMetadata(metadataBytes);
        if (dataSchemaLength != 0) {
            byte[] schemaBytes = new byte[dataSchemaLength];
            byteBuffer.position(dataSchemaStart);
            byteBuffer.get(schemaBytes);
            this._dataSchema = DataSchema.fromBytes((byte[])schemaBytes);
            this._columnOffsets = new int[this._dataSchema.size()];
            this._rowSizeInBytes = DataTableUtils.computeColumnOffsets(this._dataSchema, this._columnOffsets);
        } else {
            this._dataSchema = null;
            this._columnOffsets = null;
            this._rowSizeInBytes = 0;
        }
        if (fixedSizeDataLength != 0) {
            this._fixedSizeDataBytes = new byte[fixedSizeDataLength];
            byteBuffer.position(fixedSizeDataStart);
            byteBuffer.get(this._fixedSizeDataBytes);
            this._fixedSizeData = ByteBuffer.wrap(this._fixedSizeDataBytes);
        } else {
            this._fixedSizeDataBytes = null;
            this._fixedSizeData = null;
        }
        if (variableSizeDataLength != 0) {
            this._variableSizeDataBytes = new byte[variableSizeDataLength];
            byteBuffer.position(variableSizeDataStart);
            byteBuffer.get(this._variableSizeDataBytes);
            this._variableSizeData = ByteBuffer.wrap(this._variableSizeDataBytes);
        } else {
            this._variableSizeDataBytes = null;
            this._variableSizeData = null;
        }
    }

    private Map<String, String> deserializeMetadata(byte[] bytes) throws IOException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
            HashMap<String, String> hashMap;
            try (DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);){
                int numEntries = dataInputStream.readInt();
                HashMap<String, String> metadata = new HashMap<String, String>(numEntries);
                for (int i = 0; i < numEntries; ++i) {
                    String key = DataTableUtils.decodeString(dataInputStream);
                    String value = DataTableUtils.decodeString(dataInputStream);
                    metadata.put(key, value);
                }
                hashMap = metadata;
            }
            return hashMap;
        }
    }

    public void addException(ProcessingException processingException) {
        this._metadata.put("Exception" + processingException.getErrorCode(), processingException.getMessage());
    }

    public void addException(int errCode, String errMsg) {
        this._metadata.put("Exception" + errCode, errMsg);
    }

    public Map<Integer, String> getExceptions() {
        HashMap<Integer, String> exceptions = new HashMap<Integer, String>();
        for (String key : this._metadata.keySet()) {
            if (!key.startsWith("Exception")) continue;
            exceptions.put(Integer.parseInt(key.substring(9)), (String)this._metadata.get(key));
        }
        return exceptions;
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(2);
        dataOutputStream.writeInt(this._numRows);
        dataOutputStream.writeInt(this._numColumns);
        int dataOffset = 52;
        dataOutputStream.writeInt(dataOffset);
        byte[] dictionaryMapBytes = null;
        if (this._dictionaryMap != null) {
            dictionaryMapBytes = this.serializeDictionaryMap();
            dataOutputStream.writeInt(dictionaryMapBytes.length);
            dataOffset += dictionaryMapBytes.length;
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(dataOffset);
        byte[] metadataBytes = this.serializeMetadata();
        dataOutputStream.writeInt(metadataBytes.length);
        dataOutputStream.writeInt(dataOffset += metadataBytes.length);
        byte[] dataSchemaBytes = null;
        if (this._dataSchema != null) {
            dataSchemaBytes = this._dataSchema.toBytes();
            dataOutputStream.writeInt(dataSchemaBytes.length);
            dataOffset += dataSchemaBytes.length;
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(dataOffset);
        if (this._fixedSizeDataBytes != null) {
            dataOutputStream.writeInt(this._fixedSizeDataBytes.length);
            dataOffset += this._fixedSizeDataBytes.length;
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(dataOffset);
        if (this._variableSizeDataBytes != null) {
            dataOutputStream.writeInt(this._variableSizeDataBytes.length);
        } else {
            dataOutputStream.writeInt(0);
        }
        if (dictionaryMapBytes != null) {
            dataOutputStream.write(dictionaryMapBytes);
        }
        dataOutputStream.write(metadataBytes);
        if (dataSchemaBytes != null) {
            dataOutputStream.write(dataSchemaBytes);
        }
        if (this._fixedSizeDataBytes != null) {
            dataOutputStream.write(this._fixedSizeDataBytes);
        }
        if (this._variableSizeDataBytes != null) {
            dataOutputStream.write(this._variableSizeDataBytes);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public DataTableImplV2 toMetadataOnlyDataTable() {
        DataTableImplV2 metadataOnlyDataTable = new DataTableImplV2();
        metadataOnlyDataTable._metadata.putAll(this._metadata);
        return metadataOnlyDataTable;
    }

    public DataTableImplV2 toDataOnlyDataTable() {
        return new DataTableImplV2(this._numRows, this._dataSchema, this._dictionaryMap, this._fixedSizeDataBytes, this._variableSizeDataBytes);
    }

    private byte[] serializeMetadata() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this._metadata.size());
        for (Map.Entry entry : this._metadata.entrySet()) {
            byte[] keyBytes = ((String)entry.getKey()).getBytes(StandardCharsets.UTF_8);
            dataOutputStream.writeInt(keyBytes.length);
            dataOutputStream.write(keyBytes);
            byte[] valueBytes = ((String)entry.getValue()).getBytes(StandardCharsets.UTF_8);
            dataOutputStream.writeInt(valueBytes.length);
            dataOutputStream.write(valueBytes);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

