/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.offline;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.core.data.manager.offline.OfflineTableDataManager;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.PrimaryKey;

@ThreadSafe
public class DimensionTableDataManager
extends OfflineTableDataManager {
    private static final Map<String, DimensionTableDataManager> INSTANCES = new ConcurrentHashMap<String, DimensionTableDataManager>();
    private static final AtomicReferenceFieldUpdater<DimensionTableDataManager, Map> UPDATER = AtomicReferenceFieldUpdater.newUpdater(DimensionTableDataManager.class, Map.class, "_lookupTable");
    private volatile Map<PrimaryKey, GenericRow> _lookupTable = new HashMap<PrimaryKey, GenericRow>();
    private Schema _tableSchema;
    private List<String> _primaryKeyColumns;

    private DimensionTableDataManager() {
    }

    public static DimensionTableDataManager createInstanceByTableName(String tableNameWithType) {
        return INSTANCES.computeIfAbsent(tableNameWithType, k -> new DimensionTableDataManager());
    }

    @VisibleForTesting
    public static DimensionTableDataManager registerDimensionTable(String tableNameWithType, DimensionTableDataManager instance) {
        return INSTANCES.computeIfAbsent(tableNameWithType, k -> instance);
    }

    public static DimensionTableDataManager getInstanceByTableName(String tableNameWithType) {
        return INSTANCES.get(tableNameWithType);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this._tableSchema = ZKMetadataProvider.getTableSchema((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType);
        this._primaryKeyColumns = this._tableSchema.getPrimaryKeyColumns();
    }

    @Override
    public void addSegment(File indexDir, IndexLoadingConfig indexLoadingConfig) throws Exception {
        super.addSegment(indexDir, indexLoadingConfig);
        try {
            this.loadLookupTable();
            this._logger.info("Successfully added segment {} and loaded lookup table: {}", (Object)indexDir.getName(), (Object)this.getTableName());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error loading lookup table: %s", this.getTableName()), e);
        }
    }

    @Override
    public void removeSegment(String segmentName) {
        super.removeSegment(segmentName);
        try {
            this.loadLookupTable();
            this._logger.info("Successfully removed segment {} and reloaded lookup table: {}", (Object)segmentName, (Object)this.getTableName());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error reloading lookup table after segment remove '%s' for table: '%s'", segmentName, this.getTableName()), e);
        }
    }

    private void loadLookupTable() throws Exception {
        HashMap<PrimaryKey, GenericRow> replacement;
        Map<PrimaryKey, GenericRow> snapshot;
        do {
            snapshot = this._lookupTable;
            replacement = new HashMap<PrimaryKey, GenericRow>(snapshot.size());
            this.populate(replacement);
        } while (!UPDATER.compareAndSet(this, snapshot, replacement));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populate(Map<PrimaryKey, GenericRow> map) throws Exception {
        List<SegmentDataManager> segmentManagers = this.acquireAllSegments();
        try {
            for (SegmentDataManager segmentManager : segmentManagers) {
                IndexSegment indexSegment = segmentManager.getSegment();
                try (PinotSegmentRecordReader reader = new PinotSegmentRecordReader(indexSegment.getSegmentMetadata().getIndexDir());){
                    while (reader.hasNext()) {
                        GenericRow row = reader.next();
                        map.put(row.getPrimaryKey(this._primaryKeyColumns), row);
                    }
                }
            }
        }
        finally {
            for (SegmentDataManager segmentManager : segmentManagers) {
                this.releaseSegment(segmentManager);
            }
        }
    }

    public GenericRow lookupRowByPrimaryKey(PrimaryKey pk) {
        return this._lookupTable.get(pk);
    }

    public FieldSpec getColumnFieldSpec(String columnName) {
        return this._tableSchema.getFieldSpecFor(columnName);
    }

    public List<String> getPrimaryKeyColumns() {
        return this._primaryKeyColumns;
    }
}

