/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.metadata.instance.InstanceZKMetadata;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.core.data.manager.realtime.RealtimeSegmentDataManager;
import org.apache.pinot.core.data.manager.realtime.RealtimeTableDataManager;
import org.apache.pinot.core.data.manager.realtime.TimerService;
import org.apache.pinot.segment.local.indexsegment.mutable.MutableSegmentImpl;
import org.apache.pinot.segment.local.realtime.converter.RealtimeSegmentConverter;
import org.apache.pinot.segment.local.realtime.impl.RealtimeSegmentConfig;
import org.apache.pinot.segment.local.recordtransformer.CompositeTransformer;
import org.apache.pinot.segment.local.recordtransformer.RecordTransformer;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.utils.IngestionUtils;
import org.apache.pinot.segment.spi.MutableSegment;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.IngestionConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.metrics.PinotMeter;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.stream.StreamConsumerFactory;
import org.apache.pinot.spi.stream.StreamConsumerFactoryProvider;
import org.apache.pinot.spi.stream.StreamLevelConsumer;
import org.apache.pinot.spi.utils.CommonConstants;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HLRealtimeSegmentDataManager
extends RealtimeSegmentDataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HLRealtimeSegmentDataManager.class);
    private static final long ONE_MINUTE_IN_MILLSEC = 60000L;
    private final String _tableNameWithType;
    private final String _segmentName;
    private final String _timeColumnName;
    private final TimeUnit _timeType;
    private final RecordTransformer _recordTransformer;
    private final StreamLevelConsumer _streamLevelConsumer;
    private final File _resourceTmpDir;
    private final MutableSegmentImpl _realtimeSegment;
    private final String _tableStreamName;
    private final StreamConfig _streamConfig;
    private final long _start = System.currentTimeMillis();
    private long _segmentEndTimeThreshold;
    private AtomicLong _lastUpdatedRawDocuments = new AtomicLong(0L);
    private volatile boolean _keepIndexing = true;
    private volatile boolean _isShuttingDown = false;
    private final TimerTask _segmentStatusTask;
    private final ServerMetrics _serverMetrics;
    private final RealtimeTableDataManager _notifier;
    private Thread _indexingThread;
    private final String _sortedColumn;
    private final List<String> _invertedIndexColumns;
    private final List<String> _noDictionaryColumns;
    private final List<String> _varLengthDictionaryColumns;
    private final Logger _segmentLogger;
    private final SegmentVersion _segmentVersion;
    private PinotMeter _tableAndStreamRowsConsumed = null;
    private PinotMeter _tableRowsConsumed = null;

    public HLRealtimeSegmentDataManager(final SegmentZKMetadata segmentZKMetadata, final TableConfig tableConfig, InstanceZKMetadata instanceMetadata, RealtimeTableDataManager realtimeTableDataManager, final String resourceDataDir, final IndexLoadingConfig indexLoadingConfig, final Schema schema, final ServerMetrics serverMetrics) throws Exception {
        this._segmentVersion = indexLoadingConfig.getSegmentVersion();
        this._recordTransformer = CompositeTransformer.getDefaultTransformer((TableConfig)tableConfig, (Schema)schema);
        this._serverMetrics = serverMetrics;
        this._segmentName = segmentZKMetadata.getSegmentName();
        this._tableNameWithType = tableConfig.getTableName();
        this._timeColumnName = tableConfig.getValidationConfig().getTimeColumnName();
        Preconditions.checkNotNull((Object)this._timeColumnName, (String)"Must provide valid timeColumnName in tableConfig for realtime table {}", (Object)this._tableNameWithType);
        DateTimeFieldSpec dateTimeFieldSpec = schema.getSpecForTimeColumn(this._timeColumnName);
        Preconditions.checkNotNull((Object)dateTimeFieldSpec, (String)"Must provide field spec for time column {}", (Object)this._timeColumnName);
        this._timeType = new DateTimeFormatSpec(dateTimeFieldSpec.getFormat()).getColumnUnit();
        List sortedColumns = indexLoadingConfig.getSortedColumns();
        if (sortedColumns.isEmpty()) {
            LOGGER.info("RealtimeDataResourceZKMetadata contains no information about sorted column for segment {}", (Object)this._segmentName);
            this._sortedColumn = null;
        } else {
            String firstSortedColumn = (String)sortedColumns.get(0);
            if (schema.hasColumn(firstSortedColumn)) {
                LOGGER.info("Setting sorted column name: {} from RealtimeDataResourceZKMetadata for segment {}", (Object)firstSortedColumn, (Object)this._segmentName);
                this._sortedColumn = firstSortedColumn;
            } else {
                LOGGER.warn("Sorted column name: {} from RealtimeDataResourceZKMetadata is not existed in schema for segment {}.", (Object)firstSortedColumn, (Object)this._segmentName);
                this._sortedColumn = null;
            }
        }
        Set invertedIndexColumns = indexLoadingConfig.getInvertedIndexColumns();
        if (this._sortedColumn != null) {
            invertedIndexColumns.add(this._sortedColumn);
        }
        this._invertedIndexColumns = new ArrayList<String>(invertedIndexColumns);
        this._noDictionaryColumns = new ArrayList<String>(indexLoadingConfig.getNoDictionaryColumns());
        this._varLengthDictionaryColumns = new ArrayList<String>(indexLoadingConfig.getVarLengthDictionaryColumns());
        this._streamConfig = new StreamConfig(this._tableNameWithType, IngestionConfigUtils.getStreamConfigMap((TableConfig)tableConfig));
        this._segmentLogger = LoggerFactory.getLogger((String)(HLRealtimeSegmentDataManager.class.getName() + "_" + this._segmentName + "_" + this._streamConfig.getTopicName()));
        this._segmentLogger.info("Created segment data manager with Sorted column:{}, invertedIndexColumns:{}", (Object)this._sortedColumn, this._invertedIndexColumns);
        this._segmentEndTimeThreshold = this._start + this._streamConfig.getFlushThresholdTimeMillis();
        this._resourceTmpDir = new File(resourceDataDir, "_tmp");
        if (!this._resourceTmpDir.exists()) {
            this._resourceTmpDir.mkdirs();
        }
        StreamConsumerFactory streamConsumerFactory = StreamConsumerFactoryProvider.create((StreamConfig)this._streamConfig);
        String clientId = HLRealtimeSegmentDataManager.class.getSimpleName() + "-" + this._streamConfig.getTopicName();
        Set fieldsToRead = IngestionUtils.getFieldsForRecordExtractor((IngestionConfig)tableConfig.getIngestionConfig(), (Schema)schema);
        this._streamLevelConsumer = streamConsumerFactory.createStreamLevelConsumer(clientId, this._tableNameWithType, fieldsToRead, instanceMetadata.getGroupId(this._tableNameWithType));
        this._streamLevelConsumer.start();
        this._tableStreamName = this._tableNameWithType + "_" + this._streamConfig.getTopicName();
        final IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
        if (indexingConfig != null && indexingConfig.isAggregateMetrics()) {
            LOGGER.warn("Updating of metrics only supported for LLC consumer, ignoring.");
        }
        this._segmentLogger.info("Started {} stream provider", (Object)this._streamConfig.getType());
        int capacity = this._streamConfig.getFlushThresholdRows();
        RealtimeSegmentConfig realtimeSegmentConfig = new RealtimeSegmentConfig.Builder().setTableNameWithType(this._tableNameWithType).setSegmentName(this._segmentName).setStreamName(this._streamConfig.getTopicName()).setSchema(schema).setTimeColumnName(this._timeColumnName).setCapacity(capacity).setAvgNumMultiValues(indexLoadingConfig.getRealtimeAvgMultiValueCount()).setNoDictionaryColumns(indexLoadingConfig.getNoDictionaryColumns()).setVarLengthDictionaryColumns(indexLoadingConfig.getVarLengthDictionaryColumns()).setInvertedIndexColumns(invertedIndexColumns).setSegmentZKMetadata(segmentZKMetadata).setOffHeap(indexLoadingConfig.isRealtimeOffHeapAllocation()).setMemoryManager(HLRealtimeSegmentDataManager.getMemoryManager(realtimeTableDataManager.getConsumerDir(), this._segmentName, indexLoadingConfig.isRealtimeOffHeapAllocation(), indexLoadingConfig.isDirectRealtimeOffHeapAllocation(), serverMetrics)).setStatsHistory(realtimeTableDataManager.getStatsHistory()).setNullHandlingEnabled(indexingConfig.isNullHandlingEnabled()).build();
        this._realtimeSegment = new MutableSegmentImpl(realtimeSegmentConfig, serverMetrics);
        this._notifier = realtimeTableDataManager;
        LOGGER.info("Starting consumption on realtime consuming segment {} maxRowCount {} maxEndTime {}", new Object[]{this._segmentName, capacity, new DateTime(this._segmentEndTimeThreshold, DateTimeZone.UTC).toString()});
        this._segmentStatusTask = new TimerTask(){

            @Override
            public void run() {
                HLRealtimeSegmentDataManager.this.computeKeepIndexing();
            }
        };
        this._indexingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                block17: {
                    boolean notFull = true;
                    long exceptionSleepMillis = 50L;
                    HLRealtimeSegmentDataManager.this._segmentLogger.info("Starting to collect rows");
                    int numRowsErrored = 0;
                    GenericRow reuse = new GenericRow();
                    do {
                        reuse.clear();
                        try {
                            GenericRow consumedRow;
                            try {
                                consumedRow = HLRealtimeSegmentDataManager.this._streamLevelConsumer.next(reuse);
                                HLRealtimeSegmentDataManager.this._tableAndStreamRowsConsumed = serverMetrics.addMeteredTableValue(HLRealtimeSegmentDataManager.this._tableStreamName, (AbstractMetrics.Meter)ServerMeter.REALTIME_ROWS_CONSUMED, 1L, HLRealtimeSegmentDataManager.this._tableAndStreamRowsConsumed);
                                HLRealtimeSegmentDataManager.this._tableRowsConsumed = serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.REALTIME_ROWS_CONSUMED, 1L, HLRealtimeSegmentDataManager.this._tableRowsConsumed);
                            }
                            catch (Exception e) {
                                HLRealtimeSegmentDataManager.this._segmentLogger.warn("Caught exception while consuming row, sleeping for {} ms", (Object)exceptionSleepMillis, (Object)e);
                                ++numRowsErrored;
                                serverMetrics.addMeteredTableValue(HLRealtimeSegmentDataManager.this._tableStreamName, (AbstractMetrics.Meter)ServerMeter.REALTIME_CONSUMPTION_EXCEPTIONS, 1L);
                                serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.REALTIME_CONSUMPTION_EXCEPTIONS, 1L);
                                Uninterruptibles.sleepUninterruptibly((long)exceptionSleepMillis, (TimeUnit)TimeUnit.MILLISECONDS);
                                exceptionSleepMillis = Math.min(60000L, exceptionSleepMillis * 2L);
                                continue;
                            }
                            if (consumedRow == null) continue;
                            try {
                                GenericRow transformedRow = HLRealtimeSegmentDataManager.this._recordTransformer.transform(consumedRow);
                                if (transformedRow == null || !IngestionUtils.shouldIngestRow((GenericRow)transformedRow)) continue;
                                notFull = HLRealtimeSegmentDataManager.this._realtimeSegment.index(transformedRow, null);
                                exceptionSleepMillis = 50L;
                            }
                            catch (Exception e) {
                                HLRealtimeSegmentDataManager.this._segmentLogger.warn("Caught exception while indexing row, sleeping for {} ms, row contents {}", new Object[]{exceptionSleepMillis, consumedRow, e});
                                ++numRowsErrored;
                                Uninterruptibles.sleepUninterruptibly((long)exceptionSleepMillis, (TimeUnit)TimeUnit.MILLISECONDS);
                                exceptionSleepMillis = Math.min(60000L, exceptionSleepMillis * 2L);
                            }
                        }
                        catch (Error e) {
                            HLRealtimeSegmentDataManager.this._segmentLogger.error("Caught error in indexing thread", (Throwable)e);
                            throw e;
                        }
                    } while (notFull && HLRealtimeSegmentDataManager.this._keepIndexing && !HLRealtimeSegmentDataManager.this._isShuttingDown);
                    if (HLRealtimeSegmentDataManager.this._isShuttingDown) {
                        HLRealtimeSegmentDataManager.this._segmentLogger.info("Shutting down indexing thread!");
                        return;
                    }
                    try {
                        boolean commitSuccessful;
                        long segEndTime;
                        long segStartTime;
                        block16: {
                            if (numRowsErrored > 0) {
                                serverMetrics.addMeteredTableValue(HLRealtimeSegmentDataManager.this._tableStreamName, (AbstractMetrics.Meter)ServerMeter.ROWS_WITH_ERRORS, (long)numRowsErrored);
                            }
                            HLRealtimeSegmentDataManager.this._segmentLogger.info("Indexing threshold reached, proceeding with index conversion");
                            HLRealtimeSegmentDataManager.this._segmentStatusTask.cancel();
                            HLRealtimeSegmentDataManager.this.updateCurrentDocumentCountMetrics();
                            HLRealtimeSegmentDataManager.this._segmentLogger.info("Indexed {} raw events", (Object)HLRealtimeSegmentDataManager.this._realtimeSegment.getNumDocsIndexed());
                            File tempSegmentFolder = new File(HLRealtimeSegmentDataManager.this._resourceTmpDir, "tmp-" + System.currentTimeMillis());
                            RealtimeSegmentConverter converter = new RealtimeSegmentConverter(HLRealtimeSegmentDataManager.this._realtimeSegment, tempSegmentFolder.getAbsolutePath(), schema, HLRealtimeSegmentDataManager.this._tableNameWithType, tableConfig, segmentZKMetadata.getSegmentName(), HLRealtimeSegmentDataManager.this._sortedColumn, HLRealtimeSegmentDataManager.this._invertedIndexColumns, Collections.emptyList(), Collections.emptyList(), HLRealtimeSegmentDataManager.this._noDictionaryColumns, HLRealtimeSegmentDataManager.this._varLengthDictionaryColumns, indexingConfig.isNullHandlingEnabled());
                            HLRealtimeSegmentDataManager.this._segmentLogger.info("Trying to build segment");
                            long buildStartTime = System.nanoTime();
                            converter.build(HLRealtimeSegmentDataManager.this._segmentVersion, serverMetrics);
                            long buildEndTime = System.nanoTime();
                            HLRealtimeSegmentDataManager.this._segmentLogger.info("Built segment in {} ms", (Object)TimeUnit.MILLISECONDS.convert(buildEndTime - buildStartTime, TimeUnit.NANOSECONDS));
                            File destDir = new File(resourceDataDir, segmentZKMetadata.getSegmentName());
                            FileUtils.deleteQuietly((File)destDir);
                            FileUtils.moveDirectory((File)tempSegmentFolder.listFiles()[0], (File)destDir);
                            FileUtils.deleteQuietly((File)tempSegmentFolder);
                            segStartTime = HLRealtimeSegmentDataManager.this._realtimeSegment.getMinTime();
                            segEndTime = HLRealtimeSegmentDataManager.this._realtimeSegment.getMaxTime();
                            HLRealtimeSegmentDataManager.this._segmentLogger.info("Committing {} offsets", (Object)HLRealtimeSegmentDataManager.this._streamConfig.getType());
                            commitSuccessful = false;
                            try {
                                HLRealtimeSegmentDataManager.this._streamLevelConsumer.commit();
                                commitSuccessful = true;
                                HLRealtimeSegmentDataManager.this._streamLevelConsumer.shutdown();
                                HLRealtimeSegmentDataManager.this._segmentLogger.info("Successfully committed {} offsets, consumer release requested.", (Object)HLRealtimeSegmentDataManager.this._streamConfig.getType());
                                serverMetrics.addMeteredTableValue(HLRealtimeSegmentDataManager.this._tableStreamName, (AbstractMetrics.Meter)ServerMeter.REALTIME_OFFSET_COMMITS, 1L);
                                serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.REALTIME_OFFSET_COMMITS, 1L);
                            }
                            catch (Throwable e) {
                                HLRealtimeSegmentDataManager.this._segmentLogger.error("FATAL: Exception committing or shutting down consumer commitSuccessful={}", (Object)commitSuccessful, (Object)e);
                                serverMetrics.addMeteredTableValue(HLRealtimeSegmentDataManager.this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.REALTIME_OFFSET_COMMIT_EXCEPTIONS, 1L);
                                if (commitSuccessful) break block16;
                                HLRealtimeSegmentDataManager.this._streamLevelConsumer.shutdown();
                            }
                        }
                        try {
                            HLRealtimeSegmentDataManager.this._segmentLogger.info("Marking current segment as completed in Helix");
                            SegmentZKMetadata metadataToOverwrite = new SegmentZKMetadata(segmentZKMetadata.getSegmentName());
                            metadataToOverwrite.setStatus(CommonConstants.Segment.Realtime.Status.DONE);
                            metadataToOverwrite.setStartTime(segStartTime);
                            metadataToOverwrite.setEndTime(segEndTime);
                            metadataToOverwrite.setTimeUnit(HLRealtimeSegmentDataManager.this._timeType);
                            metadataToOverwrite.setTotalDocs((long)HLRealtimeSegmentDataManager.this._realtimeSegment.getNumDocsIndexed());
                            HLRealtimeSegmentDataManager.this._notifier.replaceHLSegment(metadataToOverwrite, indexLoadingConfig);
                            HLRealtimeSegmentDataManager.this._segmentLogger.info("Completed write of segment completion to Helix, waiting for controller to assign a new segment");
                        }
                        catch (Exception e) {
                            if (commitSuccessful) {
                                HLRealtimeSegmentDataManager.this._segmentLogger.error("Offsets were committed to Kafka but we were unable to mark this segment as completed in Helix. Manually mark the segment as completed in Helix; restarting this instance will result in data loss.", (Throwable)e);
                                break block17;
                            }
                            HLRealtimeSegmentDataManager.this._segmentLogger.warn("Caught exception while marking segment as completed in Helix. Offsets were not written, restarting the instance should be safe.", (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        HLRealtimeSegmentDataManager.this._segmentLogger.error("Caught exception in the realtime indexing thread", (Throwable)e);
                    }
                }
            }
        });
        this._indexingThread.start();
        serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.SEGMENT_COUNT, 1L);
        this._segmentLogger.debug("scheduling keepIndexing timer check");
        TimerService.TIMER.schedule(this._segmentStatusTask, 60000L, 60000L);
        this._segmentLogger.info("finished scheduling keepIndexing timer check");
    }

    @Override
    public MutableSegment getSegment() {
        return this._realtimeSegment;
    }

    @Override
    public Map<String, String> getPartitionToCurrentOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CommonConstants.ConsumerState getConsumerState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLastConsumedTimestamp() {
        throw new UnsupportedOperationException();
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    private void computeKeepIndexing() {
        if (this._keepIndexing) {
            this._segmentLogger.debug("Current indexed {} raw events", (Object)this._realtimeSegment.getNumDocsIndexed());
            if (System.currentTimeMillis() >= this._segmentEndTimeThreshold || this._realtimeSegment.getNumDocsIndexed() >= this._streamConfig.getFlushThresholdRows()) {
                if (this._realtimeSegment.getNumDocsIndexed() == 0) {
                    this._segmentLogger.info("no new events coming in, extending the end time by another hour");
                    this._segmentEndTimeThreshold = System.currentTimeMillis() + this._streamConfig.getFlushThresholdTimeMillis();
                    return;
                }
                this._segmentLogger.info("Stopped indexing due to reaching segment limit: {} raw documents indexed, segment is aged {} minutes", (Object)this._realtimeSegment.getNumDocsIndexed(), (Object)((System.currentTimeMillis() - this._start) / 60000L));
                this._keepIndexing = false;
            }
        }
        this.updateCurrentDocumentCountMetrics();
    }

    private void updateCurrentDocumentCountMetrics() {
        int currentRawDocs = this._realtimeSegment.getNumDocsIndexed();
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.DOCUMENT_COUNT, (long)currentRawDocs - this._lastUpdatedRawDocuments.get());
        this._lastUpdatedRawDocuments.set(currentRawDocs);
    }

    public void destroy() {
        LOGGER.info("Trying to shutdown RealtimeSegmentDataManager : {}!", (Object)this._segmentName);
        this._isShuttingDown = true;
        try {
            this._streamLevelConsumer.shutdown();
        }
        catch (Exception e) {
            LOGGER.error("Failed to shutdown stream consumer!", (Throwable)e);
        }
        this._keepIndexing = false;
        this._segmentStatusTask.cancel();
        this._realtimeSegment.destroy();
    }
}

