/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import java.io.File;
import java.net.URI;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.core.data.manager.realtime.SegmentUploader;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotFSSegmentUploader
implements SegmentUploader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotFSSegmentUploader.class);
    public static final int DEFAULT_SEGMENT_UPLOAD_TIMEOUT_MILLIS = 10000;
    private String _segmentStoreUriStr;
    private ExecutorService _executorService = Executors.newCachedThreadPool();
    private int _timeoutInMs;

    public PinotFSSegmentUploader(String segmentStoreDirUri, int timeoutMillis) {
        this._segmentStoreUriStr = segmentStoreDirUri;
        this._timeoutInMs = timeoutMillis;
    }

    @Override
    public URI uploadSegment(File segmentFile, LLCSegmentName segmentName) {
        if (this._segmentStoreUriStr == null || this._segmentStoreUriStr.isEmpty()) {
            return null;
        }
        Callable<URI> uploadTask = () -> {
            URI destUri = new URI(StringUtil.join((String)File.separator, (String[])new String[]{this._segmentStoreUriStr, segmentName.getTableName(), segmentName.getSegmentName() + UUID.randomUUID().toString()}));
            try {
                PinotFS pinotFS = PinotFSFactory.create((String)new URI(this._segmentStoreUriStr).getScheme());
                if (pinotFS.exists(destUri)) {
                    pinotFS.delete(destUri, true);
                }
                pinotFS.copyFromLocalFile(segmentFile, destUri);
                return destUri;
            }
            catch (Exception e) {
                LOGGER.warn("Failed copy segment tar file {} to segment store {}: {}", new Object[]{segmentFile.getName(), destUri, e});
                return null;
            }
        };
        Future<URI> future = this._executorService.submit(uploadTask);
        try {
            URI segmentLocation = future.get(this._timeoutInMs, TimeUnit.MILLISECONDS);
            LOGGER.info("Successfully upload segment {} to {}.", (Object)segmentName, (Object)segmentLocation);
            return segmentLocation;
        }
        catch (InterruptedException e) {
            LOGGER.info("Interrupted while waiting for segment upload of {} to {}.", (Object)segmentName, (Object)this._segmentStoreUriStr);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to upload file {} of segment {} for table {} ", new Object[]{segmentFile.getAbsolutePath(), segmentName, e});
        }
        return null;
    }
}

