/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.stream.StreamConsumerFactory;
import org.apache.pinot.spi.stream.StreamConsumerFactoryProvider;
import org.apache.pinot.spi.stream.StreamMetadataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeConsumptionRateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealtimeConsumptionRateManager.class);
    private static final int CACHE_ENTRY_EXPIRATION_TIME_IN_MINUTES = 10;
    private final LoadingCache<StreamConfig, Integer> _streamConfigToTopicPartitionCountMap;
    private volatile boolean _isThrottlingAllowed = false;
    @VisibleForTesting
    static final ConsumptionRateLimiter NOOP_RATE_LIMITER = n -> {};

    @VisibleForTesting
    RealtimeConsumptionRateManager(LoadingCache<StreamConfig, Integer> streamConfigToTopicPartitionCountMap) {
        this._streamConfigToTopicPartitionCountMap = streamConfigToTopicPartitionCountMap;
    }

    public static RealtimeConsumptionRateManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public void enableThrottling() {
        this._isThrottlingAllowed = true;
    }

    public ConsumptionRateLimiter createRateLimiter(StreamConfig streamConfig, String tableName) {
        int partitionCount;
        if (!streamConfig.getTopicConsumptionRateLimit().isPresent()) {
            return NOOP_RATE_LIMITER;
        }
        try {
            partitionCount = (Integer)this._streamConfigToTopicPartitionCountMap.get((Object)streamConfig);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        double topicRateLimit = (Double)streamConfig.getTopicConsumptionRateLimit().get();
        double partitionRateLimit = topicRateLimit / (double)partitionCount;
        LOGGER.info("A consumption rate limiter is set up for topic {} in table {} with rate limit: {} (topic rate limit: {}, partition count: {})", new Object[]{streamConfig.getTopicName(), tableName, partitionRateLimit, topicRateLimit, partitionCount});
        return new RateLimiterImpl(partitionRateLimit);
    }

    private static LoadingCache<StreamConfig, Integer> buildCache() {
        return CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<StreamConfig, Integer>(){

            public Integer load(StreamConfig streamConfig) throws Exception {
                String clientId = streamConfig.getTopicName() + "-consumption.rate.manager";
                StreamConsumerFactory factory = StreamConsumerFactoryProvider.create((StreamConfig)streamConfig);
                try (StreamMetadataProvider streamMetadataProvider = factory.createStreamMetadataProvider(clientId);){
                    Integer n = streamMetadataProvider.fetchPartitionCount(10000L);
                    return n;
                }
            }
        });
    }

    static /* synthetic */ LoadingCache access$000() {
        return RealtimeConsumptionRateManager.buildCache();
    }

    @VisibleForTesting
    static class RateLimiterImpl
    implements ConsumptionRateLimiter {
        private final double _rate;
        private final RateLimiter _rateLimiter;

        private RateLimiterImpl(double rate) {
            this._rate = rate;
            this._rateLimiter = RateLimiter.create((double)rate);
        }

        @Override
        public void throttle(int numMsgs) {
            if (InstanceHolder.INSTANCE._isThrottlingAllowed && numMsgs > 0) {
                this._rateLimiter.acquire(numMsgs);
            }
        }

        @VisibleForTesting
        double getRate() {
            return this._rate;
        }
    }

    @FunctionalInterface
    public static interface ConsumptionRateLimiter {
        public void throttle(int var1);
    }

    private static class InstanceHolder {
        private static final RealtimeConsumptionRateManager INSTANCE = new RealtimeConsumptionRateManager((LoadingCache<StreamConfig, Integer>)RealtimeConsumptionRateManager.access$000());

        private InstanceHolder() {
        }
    }
}

