/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import java.net.URISyntaxException;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.core.data.manager.realtime.DefaultSegmentCommitter;
import org.apache.pinot.core.data.manager.realtime.PeerSchemeSplitSegmentCommitter;
import org.apache.pinot.core.data.manager.realtime.PinotFSSegmentUploader;
import org.apache.pinot.core.data.manager.realtime.SegmentCommitter;
import org.apache.pinot.core.data.manager.realtime.Server2ControllerSegmentUploader;
import org.apache.pinot.core.data.manager.realtime.SplitSegmentCommitter;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.server.realtime.ServerSegmentCompletionProtocolHandler;
import org.apache.pinot.spi.config.table.TableConfig;
import org.slf4j.Logger;

public class SegmentCommitterFactory {
    private static Logger _logger;
    private final ServerSegmentCompletionProtocolHandler _protocolHandler;
    private final TableConfig _tableConfig;
    private final ServerMetrics _serverMetrics;
    private final IndexLoadingConfig _indexLoadingConfig;

    public SegmentCommitterFactory(Logger segmentLogger, ServerSegmentCompletionProtocolHandler protocolHandler, TableConfig tableConfig, IndexLoadingConfig indexLoadingConfig, ServerMetrics serverMetrics) {
        _logger = segmentLogger;
        this._protocolHandler = protocolHandler;
        this._tableConfig = tableConfig;
        this._indexLoadingConfig = indexLoadingConfig;
        this._serverMetrics = serverMetrics;
    }

    public SegmentCommitter createSegmentCommitter(boolean isSplitCommit, SegmentCompletionProtocol.Request.Params params, String controllerVipUrl) throws URISyntaxException {
        if (!isSplitCommit) {
            return new DefaultSegmentCommitter(_logger, this._protocolHandler, params);
        }
        if (this._tableConfig.getValidationConfig().getPeerSegmentDownloadScheme() != null) {
            PinotFSSegmentUploader segmentUploader = new PinotFSSegmentUploader(this._indexLoadingConfig.getSegmentStoreURI(), 10000);
            return new PeerSchemeSplitSegmentCommitter(_logger, this._protocolHandler, params, segmentUploader);
        }
        Server2ControllerSegmentUploader segmentUploader = new Server2ControllerSegmentUploader(_logger, this._protocolHandler.getFileUploadDownloadClient(), this._protocolHandler.getSegmentCommitUploadURL(params, controllerVipUrl), params.getSegmentName(), ServerSegmentCompletionProtocolHandler.getSegmentUploadRequestTimeoutMs(), this._serverMetrics, this._protocolHandler.getAuthToken());
        return new SplitSegmentCommitter(_logger, this._protocolHandler, params, segmentUploader);
    }
}

