/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import org.apache.pinot.core.geospatial.transform.function.BaseBinaryGeoTransformFunction;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.segment.local.utils.GeometryUtils;
import org.locationtech.jts.geom.Geometry;

public class StWithinFunction
extends BaseBinaryGeoTransformFunction {
    public static final String FUNCTION_NAME = "ST_Within";

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return INT_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        return this.transformGeometryToIntValuesSV(projectionBlock);
    }

    @Override
    public int transformGeometryToInt(Geometry firstGeometry, Geometry secondGeometry) {
        if (GeometryUtils.isGeography((Geometry)firstGeometry) || GeometryUtils.isGeography((Geometry)secondGeometry)) {
            throw new RuntimeException(String.format("%s is available for Geometry objects only", FUNCTION_NAME));
        }
        return firstGeometry.within(secondGeometry) ? 1 : 0;
    }
}

