/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator;

import org.apache.pinot.core.common.Block;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.util.trace.TraceContext;
import org.apache.pinot.spi.exception.EarlyTerminationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOperator<T extends Block>
implements Operator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseOperator.class);

    @Override
    public final T nextBlock() {
        if (Thread.interrupted()) {
            throw new EarlyTerminationException();
        }
        if (TraceContext.traceEnabled()) {
            long start = System.currentTimeMillis();
            T nextBlock = this.getNextBlock();
            long end = System.currentTimeMillis();
            String operatorName = this.getOperatorName();
            LOGGER.trace("Time spent in {}: {}", (Object)operatorName, (Object)(end - start));
            TraceContext.logTime(operatorName, end - start);
            return nextBlock;
        }
        return this.getNextBlock();
    }

    protected abstract T getNextBlock();
}

