/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.blocks.DocIdSetBlock;
import org.roaringbitmap.ImmutableBitmapDataProvider;
import org.roaringbitmap.IntIterator;

public class BitmapDocIdSetOperator
extends BaseOperator<DocIdSetBlock> {
    private static final String OPERATOR_NAME = "BitmapDocIdSetOperator";
    private static final String EXPLAIN_NAME = "DOC_ID_SET_BITMAP";
    private final IntIterator _intIterator;
    private final int[] _docIdBuffer;

    public BitmapDocIdSetOperator(ImmutableBitmapDataProvider bitmap) {
        this._intIterator = bitmap.getIntIterator();
        this._docIdBuffer = new int[10000];
    }

    public BitmapDocIdSetOperator(ImmutableBitmapDataProvider bitmap, int numDocs) {
        this._intIterator = bitmap.getIntIterator();
        this._docIdBuffer = new int[Math.min(numDocs, 10000)];
    }

    public BitmapDocIdSetOperator(ImmutableBitmapDataProvider bitmap, int[] docIdBuffer) {
        this._intIterator = bitmap.getIntIterator();
        this._docIdBuffer = docIdBuffer;
    }

    @Override
    protected DocIdSetBlock getNextBlock() {
        int bufferSize = this._docIdBuffer.length;
        int index = 0;
        while (index < bufferSize && this._intIterator.hasNext()) {
            this._docIdBuffer[index++] = this._intIterator.next();
        }
        if (index > 0) {
            return new DocIdSetBlock(this._docIdBuffer, index);
        }
        return null;
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }
}

