/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator;

import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.List;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.operator.InstanceResponseOperator;
import org.apache.pinot.core.operator.blocks.InstanceResponseBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.operator.streaming.StreamingResponseUtils;
import org.apache.pinot.segment.spi.FetchContext;
import org.apache.pinot.segment.spi.IndexSegment;

public class StreamingInstanceResponseOperator
extends InstanceResponseOperator {
    private static final String OPERATOR_NAME = "StreamingInstanceResponseOperator";
    private final StreamObserver<Server.ServerResponse> _streamObserver;

    public StreamingInstanceResponseOperator(BaseCombineOperator combinedOperator, List<IndexSegment> indexSegments, List<FetchContext> fetchContexts, StreamObserver<Server.ServerResponse> streamObserver) {
        super(combinedOperator, indexSegments, fetchContexts);
        this._streamObserver = streamObserver;
    }

    @Override
    protected InstanceResponseBlock getNextBlock() {
        DataTable metadataOnlyDataTable;
        InstanceResponseBlock nextBlock = super.getNextBlock();
        DataTable instanceResponseDataTable = nextBlock.getInstanceResponseDataTable();
        try {
            metadataOnlyDataTable = instanceResponseDataTable.toMetadataOnlyDataTable();
            this._streamObserver.onNext((Object)StreamingResponseUtils.getDataResponse(instanceResponseDataTable.toDataOnlyDataTable()));
        }
        catch (IOException e) {
            metadataOnlyDataTable = DataTableBuilder.getEmptyDataTable();
            metadataOnlyDataTable.addException(QueryException.getException((ProcessingException)QueryException.QUERY_EXECUTION_ERROR, (Exception)e));
        }
        return new InstanceResponseBlock(metadataOnlyDataTable);
    }
}

