/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.data.table.ConcurrentIndexedTable;
import org.apache.pinot.core.data.table.IndexedTable;
import org.apache.pinot.core.data.table.IntermediateRecord;
import org.apache.pinot.core.data.table.Key;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.data.table.UnboundedConcurrentIndexedTable;
import org.apache.pinot.core.operator.AcquireReleaseColumnsSegmentOperator;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByResult;
import org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.util.GroupByUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByOrderByCombineOperator
extends BaseCombineOperator {
    public static final int MAX_TRIM_THRESHOLD = 1000000000;
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupByOrderByCombineOperator.class);
    private static final String OPERATOR_NAME = "GroupByOrderByCombineOperator";
    private static final String EXPLAIN_NAME = "COMBINE_GROUPBY_ORDERBY";
    private final int _trimSize;
    private final int _trimThreshold;
    private final int _numAggregationFunctions;
    private final int _numGroupByExpressions;
    private final int _numColumns;
    private final ConcurrentLinkedQueue<ProcessingException> _mergedProcessingExceptions = new ConcurrentLinkedQueue();
    private final CountDownLatch _operatorLatch;
    private volatile IndexedTable _indexedTable;

    public GroupByOrderByCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService) {
        super(operators, GroupByOrderByCombineOperator.overrideMaxExecutionThreads(queryContext, operators.size()), executorService);
        int minTrimSize = queryContext.getMinServerGroupTrimSize();
        if (minTrimSize > 0) {
            int limit = queryContext.getLimit();
            this._trimSize = queryContext.getOrderByExpressions() != null || queryContext.getHavingFilter() != null ? GroupByUtils.getTableCapacity(limit, minTrimSize) : limit;
            this._trimThreshold = queryContext.getGroupTrimThreshold();
        } else {
            this._trimSize = Integer.MAX_VALUE;
            this._trimThreshold = Integer.MAX_VALUE;
        }
        AggregationFunction[] aggregationFunctions = this._queryContext.getAggregationFunctions();
        assert (aggregationFunctions != null);
        this._numAggregationFunctions = aggregationFunctions.length;
        assert (this._queryContext.getGroupByExpressions() != null);
        this._numGroupByExpressions = this._queryContext.getGroupByExpressions().size();
        this._numColumns = this._numGroupByExpressions + this._numAggregationFunctions;
        this._operatorLatch = new CountDownLatch(this._numTasks);
    }

    private static QueryContext overrideMaxExecutionThreads(QueryContext queryContext, int numOperators) {
        int maxExecutionThreads = queryContext.getMaxExecutionThreads();
        if (maxExecutionThreads <= 0) {
            queryContext.setMaxExecutionThreads(numOperators);
        }
        return queryContext;
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processSegments(int taskIndex) {
        for (int operatorIndex = taskIndex; operatorIndex < this._numOperators; operatorIndex += this._numTasks) {
            Operator operator = (Operator)this._operators.get(operatorIndex);
            try {
                Collection<IntermediateRecord> intermediateRecords;
                List<ProcessingException> processingExceptionsToMerge;
                if (operator instanceof AcquireReleaseColumnsSegmentOperator) {
                    ((AcquireReleaseColumnsSegmentOperator)operator).acquire();
                }
                IntermediateResultsBlock resultsBlock = (IntermediateResultsBlock)operator.nextBlock();
                if (this._indexedTable == null) {
                    GroupByOrderByCombineOperator groupByOrderByCombineOperator = this;
                    synchronized (groupByOrderByCombineOperator) {
                        if (this._indexedTable == null) {
                            DataSchema dataSchema = resultsBlock.getDataSchema();
                            this._indexedTable = this._trimThreshold >= 1000000000 ? new UnboundedConcurrentIndexedTable(dataSchema, this._queryContext, this._trimSize) : new ConcurrentIndexedTable(dataSchema, this._queryContext, this._trimSize, this._trimSize, this._trimThreshold);
                        }
                    }
                }
                if ((processingExceptionsToMerge = resultsBlock.getProcessingExceptions()) != null) {
                    this._mergedProcessingExceptions.addAll(processingExceptionsToMerge);
                }
                if ((intermediateRecords = resultsBlock.getIntermediateRecords()) == null) {
                    AggregationGroupByResult aggregationGroupByResult = resultsBlock.getAggregationGroupByResult();
                    if (aggregationGroupByResult == null) continue;
                    Iterator<GroupKeyGenerator.GroupKey> dicGroupKeyIterator = aggregationGroupByResult.getGroupKeyIterator();
                    while (dicGroupKeyIterator.hasNext()) {
                        GroupKeyGenerator.GroupKey groupKey = dicGroupKeyIterator.next();
                        Object[] keys = groupKey._keys;
                        Object[] values = Arrays.copyOf(keys, this._numColumns);
                        int groupId = groupKey._groupId;
                        for (int i = 0; i < this._numAggregationFunctions; ++i) {
                            values[this._numGroupByExpressions + i] = aggregationGroupByResult.getResultForGroupId(i, groupId);
                        }
                        this._indexedTable.upsert(new Key(keys), new Record(values));
                    }
                    continue;
                }
                for (IntermediateRecord intermediateResult : intermediateRecords) {
                    this._indexedTable.upsert(intermediateResult._key, intermediateResult._record);
                }
                continue;
            }
            finally {
                if (operator instanceof AcquireReleaseColumnsSegmentOperator) {
                    ((AcquireReleaseColumnsSegmentOperator)operator).release();
                }
            }
        }
    }

    @Override
    protected void onException(Exception e) {
        this._mergedProcessingExceptions.add(QueryException.getException((ProcessingException)QueryException.QUERY_EXECUTION_ERROR, (Exception)e));
    }

    @Override
    protected void onFinish() {
        this._operatorLatch.countDown();
    }

    @Override
    protected IntermediateResultsBlock mergeResults() throws Exception {
        long timeoutMs = this._queryContext.getEndTimeMs() - System.currentTimeMillis();
        boolean opCompleted = this._operatorLatch.await(timeoutMs, TimeUnit.MILLISECONDS);
        if (!opCompleted) {
            String errorMessage = String.format("Timed out while combining group-by order-by results after %dms, queryContext = %s", timeoutMs, this._queryContext);
            LOGGER.error(errorMessage);
            return new IntermediateResultsBlock(new TimeoutException(errorMessage));
        }
        IndexedTable indexedTable = this._indexedTable;
        indexedTable.finish(false);
        IntermediateResultsBlock mergedBlock = new IntermediateResultsBlock(indexedTable);
        if (!this._mergedProcessingExceptions.isEmpty()) {
            mergedBlock.setProcessingExceptions(new ArrayList<ProcessingException>(this._mergedProcessingExceptions));
        }
        mergedBlock.setNumResizes(indexedTable.getNumResizes());
        mergedBlock.setResizeTimeMs(indexedTable.getResizeTimeMs());
        return mergedBlock;
    }

    @Override
    protected void mergeResultsBlocks(IntermediateResultsBlock mergedBlock, IntermediateResultsBlock blockToMerge) {
    }
}

