/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutorService;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.operator.combine.MinMaxValueBasedSelectionOrderByCombineOperator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionOrderByCombineOperator
extends BaseCombineOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectionOrderByCombineOperator.class);
    private static final String OPERATOR_NAME = "SelectionOrderByCombineOperator";
    private static final String EXPLAIN_NAME = "COMBINE_SELECT_ORDERBY";
    private final int _numRowsToKeep;

    public SelectionOrderByCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService) {
        super(operators, queryContext, executorService);
        this._numRowsToKeep = queryContext.getLimit() + queryContext.getOffset();
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        List<OrderByExpressionContext> orderByExpressions = this._queryContext.getOrderByExpressions();
        assert (orderByExpressions != null);
        if (orderByExpressions.get(0).getExpression().getType() == ExpressionContext.Type.IDENTIFIER) {
            try {
                return new MinMaxValueBasedSelectionOrderByCombineOperator(this._operators, this._queryContext, this._executorService).getNextBlock();
            }
            catch (Exception e) {
                LOGGER.warn("Caught exception while using min/max value based combine, using the default combine", (Throwable)e);
            }
        }
        return super.getNextBlock();
    }

    @Override
    protected void mergeResultsBlocks(IntermediateResultsBlock mergedBlock, IntermediateResultsBlock blockToMerge) {
        DataSchema mergedDataSchema = mergedBlock.getDataSchema();
        DataSchema dataSchemaToMerge = blockToMerge.getDataSchema();
        assert (mergedDataSchema != null && dataSchemaToMerge != null);
        if (!mergedDataSchema.equals((Object)dataSchemaToMerge)) {
            String errorMessage = String.format("Data schema mismatch between merged block: %s and block to merge: %s, drop block to merge", mergedDataSchema, dataSchemaToMerge);
            LOGGER.debug(errorMessage);
            mergedBlock.addToProcessingExceptions(QueryException.getException((ProcessingException)QueryException.MERGE_RESPONSE_ERROR, (String)errorMessage));
            return;
        }
        PriorityQueue mergedRows = (PriorityQueue)mergedBlock.getSelectionResult();
        Collection<Object[]> rowsToMerge = blockToMerge.getSelectionResult();
        assert (mergedRows != null && rowsToMerge != null);
        SelectionOperatorUtils.mergeWithOrdering(mergedRows, rowsToMerge, this._numRowsToKeep);
    }
}

