/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.dociditerators;

import org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.roaringbitmap.BatchIterator;
import org.roaringbitmap.RoaringBitmapWriter;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public final class MVScanDocIdIterator
implements ScanBasedDocIdIterator {
    private final PredicateEvaluator _predicateEvaluator;
    private final ForwardIndexReader _reader;
    private final ForwardIndexReaderContext _readerContext;
    private final int _numDocs;
    private final int[] _dictIdBuffer;
    private int _nextDocId = 0;
    private long _numEntriesScanned = 0L;

    public MVScanDocIdIterator(PredicateEvaluator predicateEvaluator, ForwardIndexReader reader, int numDocs, int maxNumEntriesPerValue) {
        this._predicateEvaluator = predicateEvaluator;
        this._reader = reader;
        this._readerContext = reader.createContext();
        this._numDocs = numDocs;
        this._dictIdBuffer = new int[maxNumEntriesPerValue];
    }

    @Override
    public int next() {
        while (this._nextDocId < this._numDocs) {
            int nextDocId;
            ++this._nextDocId;
            int length = this._reader.getDictIdMV(nextDocId, this._dictIdBuffer, this._readerContext);
            this._numEntriesScanned += (long)length;
            if (!this._predicateEvaluator.applyMV(this._dictIdBuffer, length)) continue;
            return nextDocId;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int advance(int targetDocId) {
        this._nextDocId = targetDocId;
        return this.next();
    }

    @Override
    public MutableRoaringBitmap applyAnd(ImmutableRoaringBitmap docIds) {
        if (docIds.isEmpty()) {
            return new MutableRoaringBitmap();
        }
        RoaringBitmapWriter result = RoaringBitmapWriter.bufferWriter().expectedRange((long)docIds.first(), (long)docIds.last()).runCompress(false).get();
        BatchIterator docIdIterator = docIds.getBatchIterator();
        int[] buffer = new int[256];
        while (docIdIterator.hasNext()) {
            int limit = docIdIterator.nextBatch(buffer);
            for (int i = 0; i < limit; ++i) {
                int nextDocId = buffer[i];
                int length = this._reader.getDictIdMV(nextDocId, this._dictIdBuffer, this._readerContext);
                this._numEntriesScanned += (long)length;
                if (!this._predicateEvaluator.applyMV(this._dictIdBuffer, length)) continue;
                result.add(nextDocId);
            }
        }
        return (MutableRoaringBitmap)result.get();
    }

    @Override
    public long getNumEntriesScanned() {
        return this._numEntriesScanned;
    }
}

