/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.EmptyFilterBlock;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class BitmapBasedFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "BitmapBasedFilterOperator";
    private static final String EXPLAIN_NAME = "FILTER_INVERTED_INDEX";
    private final PredicateEvaluator _predicateEvaluator;
    private final InvertedIndexReader _invertedIndexReader;
    private final ImmutableRoaringBitmap _docIds;
    private final boolean _exclusive;
    private final int _numDocs;

    BitmapBasedFilterOperator(PredicateEvaluator predicateEvaluator, DataSource dataSource, int numDocs) {
        this._predicateEvaluator = predicateEvaluator;
        this._invertedIndexReader = dataSource.getInvertedIndex();
        this._docIds = null;
        this._exclusive = predicateEvaluator.isExclusive();
        this._numDocs = numDocs;
    }

    public BitmapBasedFilterOperator(ImmutableRoaringBitmap docIds, boolean exclusive, int numDocs) {
        this._predicateEvaluator = null;
        this._invertedIndexReader = null;
        this._docIds = docIds;
        this._exclusive = exclusive;
        this._numDocs = numDocs;
    }

    @Override
    protected FilterBlock getNextBlock() {
        if (this._docIds != null) {
            if (this._exclusive) {
                return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)ImmutableRoaringBitmap.flip((ImmutableRoaringBitmap)this._docIds, (long)0L, (long)this._numDocs), this._numDocs));
            }
            return new FilterBlock(new BitmapDocIdSet(this._docIds, this._numDocs));
        }
        int[] dictIds = this._exclusive ? this._predicateEvaluator.getNonMatchingDictIds() : this._predicateEvaluator.getMatchingDictIds();
        int numDictIds = dictIds.length;
        if (numDictIds == 0) {
            return EmptyFilterBlock.getInstance();
        }
        if (numDictIds == 1) {
            ImmutableRoaringBitmap docIds = (ImmutableRoaringBitmap)this._invertedIndexReader.getDocIds(dictIds[0]);
            if (this._exclusive) {
                if (docIds instanceof MutableRoaringBitmap) {
                    MutableRoaringBitmap mutableRoaringBitmap = (MutableRoaringBitmap)docIds;
                    mutableRoaringBitmap.flip(0L, (long)this._numDocs);
                    return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)mutableRoaringBitmap, this._numDocs));
                }
                return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)ImmutableRoaringBitmap.flip((ImmutableRoaringBitmap)docIds, (long)0L, (long)this._numDocs), this._numDocs));
            }
            return new FilterBlock(new BitmapDocIdSet(docIds, this._numDocs));
        }
        ImmutableRoaringBitmap[] bitmaps = new ImmutableRoaringBitmap[numDictIds];
        for (int i = 0; i < numDictIds; ++i) {
            bitmaps[i] = (ImmutableRoaringBitmap)this._invertedIndexReader.getDocIds(dictIds[i]);
        }
        MutableRoaringBitmap docIds = ImmutableRoaringBitmap.or((ImmutableRoaringBitmap[])bitmaps);
        if (this._exclusive) {
            docIds.flip(0L, (long)this._numDocs);
        }
        return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)docIds, this._numDocs));
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public String toExplainString() {
        Predicate predicate;
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(indexLookUp:inverted_index");
        Predicate predicate2 = predicate = this._predicateEvaluator != null ? this._predicateEvaluator.getPredicate() : null;
        if (predicate != null) {
            stringBuilder.append(",operator:").append(predicate.getType());
            stringBuilder.append(",predicate:").append(predicate.toString());
        }
        return stringBuilder.append(')').toString();
    }
}

