/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.operator.filter.AndFilterOperator;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.BitmapBasedFilterOperator;
import org.apache.pinot.core.operator.filter.EmptyFilterOperator;
import org.apache.pinot.core.operator.filter.ExpressionFilterOperator;
import org.apache.pinot.core.operator.filter.H3IndexFilterOperator;
import org.apache.pinot.core.operator.filter.JsonMatchFilterOperator;
import org.apache.pinot.core.operator.filter.MatchAllFilterOperator;
import org.apache.pinot.core.operator.filter.NotFilterOperator;
import org.apache.pinot.core.operator.filter.OrFilterOperator;
import org.apache.pinot.core.operator.filter.RangeIndexBasedFilterOperator;
import org.apache.pinot.core.operator.filter.ScanBasedFilterOperator;
import org.apache.pinot.core.operator.filter.SortedIndexBasedFilterOperator;
import org.apache.pinot.core.operator.filter.TextMatchFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class FilterOperatorUtils {
    public static final String USE_SCAN_REORDER_OPTIMIZATION = "useScanReorderOpt";

    private FilterOperatorUtils() {
    }

    public static BaseFilterOperator getLeafFilterOperator(PredicateEvaluator predicateEvaluator, DataSource dataSource, int numDocs) {
        if (predicateEvaluator.isAlwaysFalse()) {
            return EmptyFilterOperator.getInstance();
        }
        if (predicateEvaluator.isAlwaysTrue()) {
            return new MatchAllFilterOperator(numDocs);
        }
        Predicate.Type predicateType = predicateEvaluator.getPredicateType();
        if (predicateType == Predicate.Type.RANGE) {
            if (dataSource.getDataSourceMetadata().isSorted() && dataSource.getDictionary() != null) {
                return new SortedIndexBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
            }
            if (dataSource.getRangeIndex() != null) {
                return new RangeIndexBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
            }
            return new ScanBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
        }
        if (predicateType == Predicate.Type.REGEXP_LIKE) {
            if (dataSource.getFSTIndex() != null && dataSource.getDataSourceMetadata().isSorted()) {
                return new SortedIndexBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
            }
            if (dataSource.getFSTIndex() != null && dataSource.getInvertedIndex() != null) {
                return new BitmapBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
            }
            return new ScanBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
        }
        if (dataSource.getDataSourceMetadata().isSorted() && dataSource.getDictionary() != null) {
            return new SortedIndexBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
        }
        if (dataSource.getInvertedIndex() != null) {
            return new BitmapBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
        }
        return new ScanBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
    }

    public static BaseFilterOperator getAndFilterOperator(List<BaseFilterOperator> filterOperators, int numDocs, @Nullable Map<String, String> debugOptions) {
        ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(filterOperators.size());
        for (BaseFilterOperator filterOperator : filterOperators) {
            if (filterOperator.isResultEmpty()) {
                return EmptyFilterOperator.getInstance();
            }
            if (filterOperator.isResultMatchingAll()) continue;
            childFilterOperators.add(filterOperator);
        }
        int numChildFilterOperators = childFilterOperators.size();
        if (numChildFilterOperators == 0) {
            return new MatchAllFilterOperator(numDocs);
        }
        if (numChildFilterOperators == 1) {
            return (BaseFilterOperator)childFilterOperators.get(0);
        }
        FilterOperatorUtils.reorderAndFilterChildOperators(childFilterOperators, debugOptions);
        return new AndFilterOperator(childFilterOperators);
    }

    public static BaseFilterOperator getOrFilterOperator(List<BaseFilterOperator> filterOperators, int numDocs, @Nullable Map<String, String> debugOptions) {
        ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(filterOperators.size());
        for (BaseFilterOperator filterOperator : filterOperators) {
            if (filterOperator.isResultMatchingAll()) {
                return new MatchAllFilterOperator(numDocs);
            }
            if (filterOperator.isResultEmpty()) continue;
            childFilterOperators.add(filterOperator);
        }
        int numChildFilterOperators = childFilterOperators.size();
        if (numChildFilterOperators == 0) {
            return EmptyFilterOperator.getInstance();
        }
        if (numChildFilterOperators == 1) {
            return (BaseFilterOperator)childFilterOperators.get(0);
        }
        return new OrFilterOperator(childFilterOperators, numDocs);
    }

    public static BaseFilterOperator getNotFilterOperator(BaseFilterOperator filterOperator, int numDocs, @Nullable Map<String, String> debugOptions) {
        if (filterOperator.isResultMatchingAll()) {
            return EmptyFilterOperator.getInstance();
        }
        if (filterOperator.isResultEmpty()) {
            return new MatchAllFilterOperator(numDocs);
        }
        return new NotFilterOperator(filterOperator, numDocs);
    }

    private static void reorderAndFilterChildOperators(List<BaseFilterOperator> filterOperators, final @Nullable Map<String, String> debugOptions) {
        filterOperators.sort(new Comparator<BaseFilterOperator>(){

            @Override
            public int compare(BaseFilterOperator o1, BaseFilterOperator o2) {
                return this.getPriority(o1) - this.getPriority(o2);
            }

            int getPriority(BaseFilterOperator filterOperator) {
                if (filterOperator instanceof SortedIndexBasedFilterOperator) {
                    return 0;
                }
                if (filterOperator instanceof BitmapBasedFilterOperator) {
                    return 1;
                }
                if (filterOperator instanceof RangeIndexBasedFilterOperator || filterOperator instanceof TextMatchFilterOperator || filterOperator instanceof JsonMatchFilterOperator || filterOperator instanceof H3IndexFilterOperator) {
                    return 2;
                }
                if (filterOperator instanceof AndFilterOperator) {
                    return 3;
                }
                if (filterOperator instanceof OrFilterOperator) {
                    return 4;
                }
                if (filterOperator instanceof NotFilterOperator) {
                    return this.getPriority((NotFilterOperator)((NotFilterOperator)filterOperator).getChildFilterOperator());
                }
                if (filterOperator instanceof ScanBasedFilterOperator) {
                    return FilterOperatorUtils.getScanBasedFilterPriority((ScanBasedFilterOperator)filterOperator, 5, debugOptions);
                }
                if (filterOperator instanceof ExpressionFilterOperator) {
                    return 10;
                }
                throw new IllegalStateException(filterOperator.getClass().getSimpleName() + " should not be reordered, remove it from the list before calling this method");
            }
        });
    }

    private static int getScanBasedFilterPriority(ScanBasedFilterOperator scanBasedFilterOperator, int basePriority, @Nullable Map<String, String> debugOptions) {
        if (debugOptions != null && StringUtils.compareIgnoreCase((String)debugOptions.get(USE_SCAN_REORDER_OPTIMIZATION), (String)"false") == 0) {
            return basePriority;
        }
        if (scanBasedFilterOperator.getDataSourceMetadata().isSingleValue()) {
            return basePriority;
        }
        return basePriority + 1;
    }
}

