/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.context.predicate.JsonMatchPredicate;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.segment.spi.index.reader.JsonIndexReader;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class JsonMatchFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "JsonMatchFilterOperator";
    private static final String EXPLAIN_NAME = "FILTER_JSON_INDEX";
    private final JsonIndexReader _jsonIndex;
    private final int _numDocs;
    private final JsonMatchPredicate _predicate;

    public JsonMatchFilterOperator(JsonIndexReader jsonIndex, JsonMatchPredicate predicate, int numDocs) {
        this._jsonIndex = jsonIndex;
        this._predicate = predicate;
        this._numDocs = numDocs;
    }

    @Override
    protected FilterBlock getNextBlock() {
        return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)this._jsonIndex.getMatchingDocIds(this._predicate.getValue()), this._numDocs));
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(indexLookUp:json_index");
        stringBuilder.append(",operator:").append(this._predicate.getType());
        stringBuilder.append(",predicate:").append(this._predicate.toString());
        return stringBuilder.append(')').toString();
    }
}

