/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.NotDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;

public class NotFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "NotFilterOperator";
    private static final String EXPLAIN_NAME = "FILTER_NOT";
    private final BaseFilterOperator _filterOperator;
    private final int _numDocs;

    public NotFilterOperator(BaseFilterOperator filterOperator, int numDocs) {
        this._filterOperator = filterOperator;
        this._numDocs = numDocs;
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.singletonList(this._filterOperator);
    }

    @Override
    @Nullable
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    protected FilterBlock getNextBlock() {
        return new FilterBlock(new NotDocIdSet(((FilterBlock)this._filterOperator.nextBlock()).getBlockDocIdSet(), this._numDocs));
    }

    public Operator getChildFilterOperator() {
        return this._filterOperator;
    }
}

