/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.ScanBasedFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.RangePredicateEvaluatorFactory;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.RangeIndexReader;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class RangeIndexBasedFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "RangeFilterOperator";
    private static final String EXPLAIN_NAME = "FILTER_RANGE_INDEX";
    private final PredicateEvaluator _rangePredicateEvaluator;
    private final DataSource _dataSource;
    private final int _numDocs;

    public RangeIndexBasedFilterOperator(PredicateEvaluator rangePredicateEvaluator, DataSource dataSource, int numDocs) {
        this._rangePredicateEvaluator = rangePredicateEvaluator;
        this._dataSource = dataSource;
        this._numDocs = numDocs;
    }

    @Override
    protected FilterBlock getNextBlock() {
        ImmutableRoaringBitmap partialMatches;
        ImmutableRoaringBitmap matches;
        RangeIndexReader rangeIndexReader = this._dataSource.getRangeIndex();
        assert (rangeIndexReader != null);
        if (this._rangePredicateEvaluator instanceof RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator) {
            int startDictId = ((RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator)this._rangePredicateEvaluator).getStartDictId();
            int endDictId = ((RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator)this._rangePredicateEvaluator).getEndDictId() - 1;
            matches = (ImmutableRoaringBitmap)rangeIndexReader.getMatchingDocIds(startDictId, endDictId);
            partialMatches = (ImmutableRoaringBitmap)rangeIndexReader.getPartiallyMatchingDocIds(startDictId, endDictId);
        } else {
            switch (this._rangePredicateEvaluator.getDataType()) {
                case INT: {
                    int lowerBound = ((RangePredicateEvaluatorFactory.IntRawValueBasedRangePredicateEvaluator)this._rangePredicateEvaluator).geLowerBound();
                    int upperBound = ((RangePredicateEvaluatorFactory.IntRawValueBasedRangePredicateEvaluator)this._rangePredicateEvaluator).getUpperBound();
                    matches = (ImmutableRoaringBitmap)rangeIndexReader.getMatchingDocIds(lowerBound, upperBound);
                    partialMatches = (ImmutableRoaringBitmap)rangeIndexReader.getPartiallyMatchingDocIds(lowerBound, upperBound);
                    break;
                }
                case LONG: {
                    long lowerBound = ((RangePredicateEvaluatorFactory.LongRawValueBasedRangePredicateEvaluator)this._rangePredicateEvaluator).geLowerBound();
                    long upperBound = ((RangePredicateEvaluatorFactory.LongRawValueBasedRangePredicateEvaluator)this._rangePredicateEvaluator).getUpperBound();
                    matches = (ImmutableRoaringBitmap)rangeIndexReader.getMatchingDocIds(lowerBound, upperBound);
                    partialMatches = (ImmutableRoaringBitmap)rangeIndexReader.getPartiallyMatchingDocIds(lowerBound, upperBound);
                    break;
                }
                case FLOAT: {
                    float lowerBound = ((RangePredicateEvaluatorFactory.FloatRawValueBasedRangePredicateEvaluator)this._rangePredicateEvaluator).geLowerBound();
                    float upperBound = ((RangePredicateEvaluatorFactory.FloatRawValueBasedRangePredicateEvaluator)this._rangePredicateEvaluator).getUpperBound();
                    matches = (ImmutableRoaringBitmap)rangeIndexReader.getMatchingDocIds(lowerBound, upperBound);
                    partialMatches = (ImmutableRoaringBitmap)rangeIndexReader.getPartiallyMatchingDocIds(lowerBound, upperBound);
                    break;
                }
                case DOUBLE: {
                    double lowerBound = ((RangePredicateEvaluatorFactory.DoubleRawValueBasedRangePredicateEvaluator)this._rangePredicateEvaluator).geLowerBound();
                    double upperBound = ((RangePredicateEvaluatorFactory.DoubleRawValueBasedRangePredicateEvaluator)this._rangePredicateEvaluator).getUpperBound();
                    matches = (ImmutableRoaringBitmap)rangeIndexReader.getMatchingDocIds(lowerBound, upperBound);
                    partialMatches = (ImmutableRoaringBitmap)rangeIndexReader.getPartiallyMatchingDocIds(lowerBound, upperBound);
                    break;
                }
                default: {
                    throw new IllegalStateException("String and Bytes data type not supported for Range Indexing");
                }
            }
        }
        if (partialMatches != null) {
            ScanBasedFilterOperator scanBasedFilterOperator = new ScanBasedFilterOperator(this._rangePredicateEvaluator, this._dataSource, this._numDocs);
            final FilterBlockDocIdSet scanBasedDocIdSet = scanBasedFilterOperator.getNextBlock().getBlockDocIdSet();
            MutableRoaringBitmap docIds = ((ScanBasedDocIdIterator)scanBasedDocIdSet.iterator()).applyAnd(partialMatches);
            if (matches != null) {
                docIds.or(matches);
            }
            return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)docIds, this._numDocs){

                @Override
                public long getNumEntriesScannedInFilter() {
                    return scanBasedDocIdSet.getNumEntriesScannedInFilter();
                }
            });
        }
        return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)(matches == null ? new MutableRoaringBitmap() : matches), this._numDocs));
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(indexLookUp:range_index");
        stringBuilder.append(",operator:").append(this._rangePredicateEvaluator.getPredicateType());
        stringBuilder.append(",predicate:").append(this._rangePredicateEvaluator.getPredicate().toString());
        return stringBuilder.append(')').toString();
    }
}

