/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.MVScanDocIdSet;
import org.apache.pinot.core.operator.docidsets.SVScanDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;

public class ScanBasedFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "ScanBasedFilterOperator";
    private static final String EXPLAIN_NAME = "FILTER_FULL_SCAN";
    private final PredicateEvaluator _predicateEvaluator;
    private final DataSource _dataSource;
    private final int _numDocs;

    ScanBasedFilterOperator(PredicateEvaluator predicateEvaluator, DataSource dataSource, int numDocs) {
        this._predicateEvaluator = predicateEvaluator;
        this._dataSource = dataSource;
        this._numDocs = numDocs;
    }

    @Override
    protected FilterBlock getNextBlock() {
        DataSourceMetadata dataSourceMetadata = this._dataSource.getDataSourceMetadata();
        if (dataSourceMetadata.isSingleValue()) {
            return new FilterBlock(new SVScanDocIdSet(this._predicateEvaluator, this._dataSource.getForwardIndex(), this._numDocs));
        }
        return new FilterBlock(new MVScanDocIdSet(this._predicateEvaluator, this._dataSource.getForwardIndex(), this._numDocs, dataSourceMetadata.getMaxNumValuesPerMVEntry()));
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(operator:").append(this._predicateEvaluator.getPredicateType());
        stringBuilder.append(",predicate:").append(this._predicateEvaluator.getPredicate().toString());
        return stringBuilder.append(')').toString();
    }

    public DataSourceMetadata getDataSourceMetadata() {
        return this._dataSource.getDataSourceMetadata();
    }
}

