/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import java.util.Arrays;
import org.apache.pinot.common.request.context.predicate.EqPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateUtils;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.spi.utils.TimestampUtils;

public class EqualsPredicateEvaluatorFactory {
    private EqualsPredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(EqPredicate eqPredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
        return new DictionaryBasedEqPredicateEvaluator(eqPredicate, dictionary, dataType);
    }

    public static BaseRawValueBasedPredicateEvaluator newRawValueBasedEvaluator(EqPredicate eqPredicate, FieldSpec.DataType dataType) {
        String value = eqPredicate.getValue();
        switch (dataType) {
            case INT: {
                return new IntRawValueBasedEqPredicateEvaluator(eqPredicate, Integer.parseInt(value));
            }
            case LONG: {
                return new LongRawValueBasedEqPredicateEvaluator(eqPredicate, Long.parseLong(value));
            }
            case FLOAT: {
                return new FloatRawValueBasedEqPredicateEvaluator(eqPredicate, Float.parseFloat(value));
            }
            case DOUBLE: {
                return new DoubleRawValueBasedEqPredicateEvaluator(eqPredicate, Double.parseDouble(value));
            }
            case BOOLEAN: {
                return new IntRawValueBasedEqPredicateEvaluator(eqPredicate, BooleanUtils.toInt((String)value));
            }
            case TIMESTAMP: {
                return new LongRawValueBasedEqPredicateEvaluator(eqPredicate, TimestampUtils.toMillisSinceEpoch((String)value));
            }
            case STRING: {
                return new StringRawValueBasedEqPredicateEvaluator(eqPredicate, value);
            }
            case BYTES: {
                return new BytesRawValueBasedEqPredicateEvaluator(eqPredicate, BytesUtils.toBytes((String)value));
            }
        }
        throw new IllegalStateException("Unsupported data type: " + dataType);
    }

    private static final class BytesRawValueBasedEqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final byte[] _matchingValue;

        BytesRawValueBasedEqPredicateEvaluator(EqPredicate eqPredicate, byte[] matchingValue) {
            super((Predicate)eqPredicate);
            this._matchingValue = matchingValue;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.BYTES;
        }

        @Override
        public boolean applySV(byte[] value) {
            return Arrays.equals(this._matchingValue, value);
        }
    }

    private static final class StringRawValueBasedEqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final String _matchingValue;

        StringRawValueBasedEqPredicateEvaluator(EqPredicate eqPredicate, String matchingValue) {
            super((Predicate)eqPredicate);
            this._matchingValue = matchingValue;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.STRING;
        }

        @Override
        public boolean applySV(String value) {
            return this._matchingValue.equals(value);
        }
    }

    private static final class DoubleRawValueBasedEqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final double _matchingValue;

        DoubleRawValueBasedEqPredicateEvaluator(EqPredicate eqPredicate, double matchingValue) {
            super((Predicate)eqPredicate);
            this._matchingValue = matchingValue;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.DOUBLE;
        }

        @Override
        public boolean applySV(double value) {
            return this._matchingValue == value;
        }
    }

    private static final class FloatRawValueBasedEqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final float _matchingValue;

        FloatRawValueBasedEqPredicateEvaluator(EqPredicate eqPredicate, float matchingValue) {
            super((Predicate)eqPredicate);
            this._matchingValue = matchingValue;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.FLOAT;
        }

        @Override
        public boolean applySV(float value) {
            return this._matchingValue == value;
        }
    }

    private static final class LongRawValueBasedEqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final long _matchingValue;

        LongRawValueBasedEqPredicateEvaluator(EqPredicate eqPredicate, long matchingValue) {
            super((Predicate)eqPredicate);
            this._matchingValue = matchingValue;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.LONG;
        }

        @Override
        public boolean applySV(long value) {
            return this._matchingValue == value;
        }
    }

    private static final class IntRawValueBasedEqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final int _matchingValue;

        IntRawValueBasedEqPredicateEvaluator(EqPredicate eqPredicate, int matchingValue) {
            super((Predicate)eqPredicate);
            this._matchingValue = matchingValue;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.INT;
        }

        @Override
        public boolean applySV(int value) {
            return this._matchingValue == value;
        }
    }

    private static final class DictionaryBasedEqPredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final int _matchingDictId;
        final int[] _matchingDictIds;

        DictionaryBasedEqPredicateEvaluator(EqPredicate eqPredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
            super((Predicate)eqPredicate);
            String predicateValue = PredicateUtils.getStoredValue(eqPredicate.getValue(), dataType);
            this._matchingDictId = dictionary.indexOf(predicateValue);
            if (this._matchingDictId >= 0) {
                this._matchingDictIds = new int[]{this._matchingDictId};
                if (dictionary.length() == 1) {
                    this._alwaysTrue = true;
                }
            } else {
                this._matchingDictIds = new int[0];
                this._alwaysFalse = true;
            }
        }

        @Override
        public boolean applySV(int dictId) {
            return this._matchingDictId == dictId;
        }

        @Override
        public int[] getMatchingDictIds() {
            return this._matchingDictIds;
        }
    }
}

